/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.Extensions;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.ui.internal.actions.MountAction;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.actions.CompoundContributionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MountMenu
extends CompoundContributionItem
implements ISelectionChangedListener {
    private List<String> protocols = new ArrayList<String>();
    private List<IGridStorage> sources = new ArrayList<IGridStorage>();

    protected MountMenu() {
        this.checkVisible();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.protocols = null;
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)iSelection).toList();
            this.sources.clear();
            for (Object e : list) {
                if (!(e instanceof IGridStorage)) continue;
                IGridStorage iGridStorage = (IGridStorage)e;
                this.sources.add(iGridStorage);
                List<String> list2 = this.getProtocols(iGridStorage);
                this.mergeProtocols(list2);
            }
        }
        this.checkVisible();
    }

    protected IContributionItem[] getContributionItems() {
        IContributionItem[] iContributionItemArray = new IContributionItem[]{};
        if (!this.protocols.isEmpty()) {
            iContributionItemArray = new IContributionItem[this.protocols.size()];
            int n = 0;
            while (n < this.protocols.size()) {
                IAction iAction = this.getAction(this.protocols.get(n));
                iContributionItemArray[n] = new ActionContributionItem(iAction);
                ++n;
            }
        }
        return iContributionItemArray;
    }

    protected IAction getAction(String string) {
        IGridStorage[] iGridStorageArray = this.sources.toArray(new IGridStorage[this.sources.size()]);
        MountAction mountAction = new MountAction(iGridStorageArray, string);
        return mountAction;
    }

    protected List<String> getProtocols(IGridStorage iGridStorage) {
        ArrayList<String> arrayList = new ArrayList<String>();
        URI[] uRIArray = this.filterProtocols(iGridStorage.getAccessTokens());
        if (uRIArray != null) {
            int n = 0;
            while (n < uRIArray.length) {
                arrayList.add(MountMenu.getProtocol(uRIArray[n]));
                ++n;
            }
        }
        return arrayList;
    }

    private URI[] filterProtocols(URI[] uRIArray) {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        List list = Extensions.getRegisteredFilesystemSchemes();
        URI[] uRIArray2 = uRIArray;
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI uRI = uRIArray2[n2];
            String string = uRI.getScheme();
            if (list.contains(string)) {
                arrayList.add(uRI);
            }
            ++n2;
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    private void checkVisible() {
        this.setVisible(this.protocols != null && !this.protocols.isEmpty());
    }

    private void mergeProtocols(List<String> list) {
        if (this.protocols == null && list != null && !list.isEmpty()) {
            this.protocols = new ArrayList<String>();
            for (String string : list) {
                if (this.protocols.contains(string)) continue;
                this.protocols.add(string);
            }
        } else if (this.protocols != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.protocols) {
                if (!list.contains(string)) continue;
                arrayList.add(string);
            }
            this.protocols = arrayList;
        }
    }

    protected static String getProtocol(URI uRI) {
        return String.valueOf(uRI.getScheme()) + ":" + uRI.getPort();
    }
}

