/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.actions.OpenElementAction;
import eu.geclipse.ui.views.GridModelViewPart;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;

public class OpenActions
extends ActionGroup {
    protected OpenElementAction openElementAction;
    private IWorkbenchSite site;

    public OpenActions(GridModelViewPart gridModelViewPart) {
        this.site = gridModelViewPart.getSite();
        IWorkbenchPage iWorkbenchPage = this.site.getPage();
        ISelectionProvider iSelectionProvider = this.site.getSelectionProvider();
        this.openElementAction = new OpenElementAction(iWorkbenchPage);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.openElementAction);
        gridModelViewPart.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x100000C) {
                    OpenActions.this.openElementAction.run();
                }
            }
        });
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.site.getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.openElementAction);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        if (this.openElementAction.isEnabled()) {
            iMenuManager.appendToGroup("group.open", (IAction)this.openElementAction);
        }
        super.fillContextMenu(iMenuManager);
    }

    public void delegateOpenEvent(OpenEvent openEvent) {
        ISelection iSelection = openEvent.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Object object = iStructuredSelection.getFirstElement();
            if (!(object instanceof IResource) && object instanceof IAdaptable) {
                object = ((IAdaptable)object).getAdapter(IResource.class);
            }
            if (object instanceof IFile) {
                this.openElementAction.selectionChanged(iStructuredSelection);
                this.openElementAction.run();
            }
        }
    }
}

