/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.OpenJobAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.actions.OpenFileAction;

public class OpenElementAction
extends Action
implements ISelectionChangedListener {
    private OpenFileAction openFileAction;
    private OpenJobAction openJobAction;
    private BaseSelectionListenerAction activeAction;

    protected OpenElementAction(IWorkbenchPage iWorkbenchPage) {
        super(Messages.getString("OpenElementAction.open_element_action_text"));
        this.openFileAction = new OpenFileAction(iWorkbenchPage);
        this.openJobAction = new OpenJobAction(iWorkbenchPage);
    }

    public void run() {
        if (this.activeAction != null) {
            this.activeAction.run();
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)iSelection);
        } else {
            this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.activeAction = null;
        this.activeAction = this.isGridJob(iStructuredSelection) ? this.openJobAction : this.openFileAction;
        if (this.activeAction != null) {
            this.activeAction.selectionChanged(iStructuredSelection);
            this.setEnabled(this.activeAction.isEnabled());
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean isGridConnection(IStructuredSelection iStructuredSelection) {
        return iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof IGridConnectionElement;
    }

    protected boolean isGridJob(IStructuredSelection iStructuredSelection) {
        return iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof IGridJob;
    }
}

