/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.TransferAction;
import eu.geclipse.ui.internal.transfer.GridElementTransferOperation;
import eu.geclipse.ui.views.GridModelViewPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class PasteAction
extends TransferAction {
    GridModelViewPart view;

    public PasteAction(GridModelViewPart gridModelViewPart, Clipboard clipboard) {
        super(Messages.getString("PasteAction.paste_action_text"), clipboard);
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor imageDescriptor = iSharedImages.getImageDescriptor("IMG_TOOL_PASTE");
        this.setImageDescriptor(imageDescriptor);
        this.view = gridModelViewPart;
    }

    public void run() {
        Clipboard clipboard = this.getClipboard();
        LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getInstance();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)clipboard.getContents((Transfer)localSelectionTransfer);
        IStructuredSelection iStructuredSelection2 = this.getStructuredSelection();
        this.startTransfer(iStructuredSelection, iStructuredSelection2);
    }

    protected void startTransfer(IStructuredSelection iStructuredSelection, IStructuredSelection iStructuredSelection2) {
        if (!this.isEmpty((ISelection)iStructuredSelection) && !this.isEmpty((ISelection)iStructuredSelection2)) {
            Object[] objectArray = iStructuredSelection.toArray();
            IGridElement[] iGridElementArray = new IGridElement[iStructuredSelection.size()];
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof IGridElement) {
                    iGridElementArray[n] = (IGridElement)objectArray[n];
                }
                ++n;
            }
            Object object = iStructuredSelection2.getFirstElement();
            IGridContainer iGridContainer = null;
            if (object instanceof IGridContainer) {
                iGridContainer = (IGridContainer)object;
            }
            if (iGridContainer != null) {
                this.startTransfer(iGridElementArray, iGridContainer);
            }
        }
    }

    protected void startTransfer(IGridElement[] iGridElementArray, IGridContainer iGridContainer) {
        GridElementTransferOperation gridElementTransferOperation = new GridElementTransferOperation(iGridElementArray, iGridContainer, false);
        gridElementTransferOperation.setUser(true);
        gridElementTransferOperation.schedule();
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        boolean bl = super.updateSelection(iStructuredSelection);
        if (bl && iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof IGridContainer) {
            Clipboard clipboard = this.getClipboard();
            TransferData[] transferDataArray = clipboard.getAvailableTypes();
            LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getInstance();
            bl = false;
            TransferData[] transferDataArray2 = transferDataArray;
            int n = transferDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransferData transferData = transferDataArray2[n2];
                if (localSelectionTransfer.isSupportedType(transferData)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    private boolean isEmpty(ISelection iSelection) {
        return iSelection == null || iSelection.isEmpty();
    }
}

