/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.internal.actions.Messages;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class RefreshAction
extends BaseSelectionListenerAction {
    private org.eclipse.ui.actions.RefreshAction resourcesRefresh;

    protected RefreshAction(Shell shell) {
        super(Messages.getString("RefreshAction.refresh"));
        this.resourcesRefresh = new org.eclipse.ui.actions.RefreshAction(shell);
    }

    public void run() {
        if (this.resourcesRefresh.isEnabled()) {
            IStructuredSelection iStructuredSelection = this.getStructuredSelection();
            this.activateConnections(iStructuredSelection);
            this.resourcesRefresh.run();
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        boolean bl = false;
        IStructuredSelection iStructuredSelection2 = this.filterResources(iStructuredSelection);
        IStructuredSelection iStructuredSelection3 = this.filterVirtualElements(iStructuredSelection);
        if (iStructuredSelection2.size() + iStructuredSelection3.size() == iStructuredSelection.size()) {
            this.resourcesRefresh.selectionChanged(iStructuredSelection2);
            bl = this.resourcesRefresh.isEnabled();
        }
        return bl;
    }

    private void activateConnections(IStructuredSelection iStructuredSelection) {
        for (Object e : iStructuredSelection) {
            if (!(e instanceof IGridConnectionElement)) continue;
            IGridConnectionElement iGridConnectionElement = (IGridConnectionElement)e;
            iGridConnectionElement.setDirty();
        }
    }

    private IStructuredSelection filterResources(IStructuredSelection iStructuredSelection) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        for (Object e : iStructuredSelection) {
            IResource iResource = this.getResource(e);
            if (iResource == null) continue;
            arrayList.add(iResource);
        }
        return new StructuredSelection(arrayList);
    }

    private IStructuredSelection filterVirtualElements(IStructuredSelection iStructuredSelection) {
        ArrayList<IGridElement> arrayList = new ArrayList<IGridElement>();
        for (Object e : iStructuredSelection) {
            IGridElement iGridElement;
            if (!(e instanceof IGridElement) || !(iGridElement = (IGridElement)e).isVirtual()) continue;
            arrayList.add(iGridElement);
        }
        return new StructuredSelection(arrayList);
    }

    private IResource getResource(Object object) {
        IResource iResource = null;
        if (object instanceof IResource) {
            iResource = (IResource)object;
        } else if (object instanceof IAdaptable) {
            iResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return iResource;
    }
}

