/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.CoreProblems;
import eu.geclipse.core.GridException;
import eu.geclipse.core.model.IGridVisualization;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.views.VisualizationView;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;

public class RenderLocalVTKPipelineAction
extends SelectionListenerAction {
    private IWorkbenchSite site;
    private ArrayList<IGridVisualization> vis;

    protected RenderLocalVTKPipelineAction(String string) {
        super(string);
    }

    public RenderLocalVTKPipelineAction(IWorkbenchPartSite iWorkbenchPartSite) {
        super(Messages.getString("RenderLocalVTKPipelineAction.title"));
        this.site = iWorkbenchPartSite;
    }

    public void run() {
        Object object = this.getStructuredSelection().getFirstElement();
        if (object != null && this.checkForPipelineCompletion(object)) {
            try {
                IViewPart iViewPart = this.site.getPage().showView("eu.geclipse.ui.views.visualizationview");
                iViewPart.setFocus();
                ((VisualizationView)iViewPart).setPipeline((IGridVisualization)object, "local");
                ((VisualizationView)iViewPart).render();
            }
            catch (PartInitException partInitException) {
                NewProblemDialog.openProblem(null, Messages.getString("RenderLocalVTKPipelineAction.errorDialogTitle"), Messages.getString("RenderLocalVTKPipelineAction.errorOpeningView"), partInitException);
            }
        } else {
            GridException gridException = new GridException(CoreProblems.FILE_ACCESS_PROBLEM, Messages.getString("RenderLocalVTKPipelineAction.elementNotVisualizable"));
            NewProblemDialog.openProblem(null, Messages.getString("RenderLocalVTKPipelineAction.errorDialogTitle"), Messages.getString("RenderLocalVTKPipelineAction.errorInfo"), gridException);
        }
    }

    private boolean checkForPipelineCompletion(Object object) {
        return true;
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        this.vis = new ArrayList();
        boolean bl = super.updateSelection(iStructuredSelection);
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext() && bl) {
            Object e = iterator.next();
            boolean bl2 = this.isVisualizable(e);
            bl &= bl2;
            if (!bl2) continue;
            this.vis.add((IGridVisualization)e);
        }
        return bl;
    }

    protected boolean isVisualizable(Object object) {
        return object instanceof IGridVisualization;
    }
}

