/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridJobCreator;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferJsdl2JdlAction
extends SelectionListenerAction {
    private IWorkbenchSite site;
    private List<IGridJobDescription> jobDescriptions;
    private List<IGridJobCreator> jobCreators;

    protected TransferJsdl2JdlAction(IWorkbenchSite iWorkbenchSite) {
        super(Messages.getString("TransferJsdl2JdlAction.title"));
        this.site = iWorkbenchSite;
    }

    public void run() {
        try {
            IGridJobDescription iGridJobDescription = this.jobDescriptions.get(0);
            IFile iFile = (IFile)iGridJobDescription.getResource();
            InputStream inputStream = null;
            inputStream = iFile.getContents(true);
            String string = String.valueOf(iGridJobDescription.getName()) + ".jdl";
            IFolder iFolder = (IFolder)iGridJobDescription.getParent().getResource();
            IFile iFile2 = iFolder.getFile(string);
            if (iFile2.exists()) {
                iFile2.delete(true, null);
            }
            Bundle bundle = Activator.getDefault().getBundle();
            Path path = new Path("jsdl2jdl.xslt");
            InputStream inputStream2 = null;
            inputStream2 = FileLocator.openStream((Bundle)bundle, (IPath)path, (boolean)false);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            StreamSource streamSource = new StreamSource(inputStreamReader);
            StreamSource streamSource2 = new StreamSource(inputStream2);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer = transformerFactory.newTransformer(streamSource2);
            transformer.transform(streamSource, streamResult);
            inputStream2.close();
            inputStreamReader.close();
            ((Writer)stringWriter).close();
            byte[] byArray = ((Object)stringWriter).toString().getBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            iFile2.create((InputStream)byteArrayInputStream, false, null);
            IWorkbenchPage iWorkbenchPage = this.site.getPage();
            IEditorDescriptor iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFile2.getName());
            iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile2), iEditorDescriptor.getId());
        }
        catch (CoreException coreException) {
            NewProblemDialog.openProblem(this.site.getShell(), Messages.getString("TransferJsdl2JdlAction.DialogTitleCoreException"), Messages.getString("TransferJsdl2JdlAction.DialogMessageCoreException"), coreException);
        }
        catch (IOException iOException) {
            NewProblemDialog.openProblem(this.site.getShell(), Messages.getString("TransferJsdl2JdlAction.DialogTitleIOException"), Messages.getString("TransferJsdl2JdlAction.DialogMessageIOException"), iOException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            NewProblemDialog.openProblem(this.site.getShell(), Messages.getString("TransferJsdl2JdlAction.DialogTitleTransformerConfigException"), Messages.getString("TransferJsdl2JdlAction.DialogMessageTransformationConfigException"), transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            NewProblemDialog.openProblem(this.site.getShell(), Messages.getString("TransferJsdl2JdlAction.DialogTitleTransformerException"), Messages.getString("TransferJsdl2JdlAction.DialogMessageTransformerException"), transformerException);
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        this.jobCreators = null;
        this.jobDescriptions = new ArrayList<IGridJobDescription>();
        boolean bl = super.updateSelection(iStructuredSelection);
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext() && bl) {
            Object e = iterator.next();
            boolean bl2 = this.isJobDescription(e);
            bl &= bl2;
            if (!bl2) continue;
            this.jobDescriptions.add((IGridJobDescription)e);
            List<Object> list = GridModel.getJobCreators((IGridJobDescription)((IGridJobDescription)e));
            this.jobCreators = this.jobCreators == null ? list : this.mergeCreators(this.jobCreators, (List<IGridJobCreator>)list);
        }
        return bl && this.jobCreators != null;
    }

    protected boolean isJobDescription(Object object) {
        return object instanceof IGridJobDescription;
    }

    private List<IGridJobCreator> mergeCreators(List<IGridJobCreator> list, List<IGridJobCreator> list2) {
        ArrayList<IGridJobCreator> arrayList = new ArrayList<IGridJobCreator>();
        for (IGridJobCreator iGridJobCreator : list) {
            boolean bl = false;
            for (IGridJobCreator iGridJobCreator2 : list2) {
                if (!iGridJobCreator.getClass().equals(iGridJobCreator2.getClass())) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList.add(iGridJobCreator);
        }
        return arrayList;
    }
}

