/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.jobs.GridJob;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.SelectionListenerAction;

public class UpdateJobStatusAction
extends SelectionListenerAction {
    ArrayList<IGridJob> selectedJobs = new ArrayList();
    private IWorkbenchWindow workbenchWindow;

    public UpdateJobStatusAction(IWorkbenchWindow iWorkbenchWindow) {
        super(Messages.getString("UpdateJobStatusAction.title"));
        this.workbenchWindow = iWorkbenchWindow;
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("UpdateJobStatus"));
    }

    protected UpdateJobStatusAction() {
        super(Messages.getString("UpdateJobStatusAction.title"));
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("UpdateJobStatus"));
    }

    public void run() {
        if (this.selectedJobs.size() > 0) {
            final ArrayList arrayList = (ArrayList)this.selectedJobs.clone();
            Job job = new Job(Messages.getString("UpdateJobStatusAction.manual_update_job_name")){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    iProgressMonitor.beginTask(Messages.getString("UpdateJobStatusAction.manual_update_task_name"), arrayList.size());
                    for (IGridJob iGridJob : arrayList) {
                        if (iProgressMonitor.isCanceled()) continue;
                        iProgressMonitor.subTask(String.valueOf(Messages.getString("UpdateJobStatusAction.manual_update_subtask_name")) + iGridJob.getID().getJobID());
                        new SubProgressMonitor(iProgressMonitor, 1);
                        iGridJob.updateJobStatus();
                        GridModel.getJobManager().jobStatusChanged(iGridJob);
                        iProgressMonitor.worked(1);
                    }
                    iProgressMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        this.selectedJobs.clear();
        for (Object e : iStructuredSelection) {
            if (!(e instanceof GridJob)) continue;
            this.selectedJobs.add((IGridJob)((GridJob)e));
        }
        if (this.selectedJobs.size() > 0) {
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(false);
        }
        return super.updateSelection(iStructuredSelection) && this.selectedJobs.size() > 0;
    }
}

