/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.providers.ConfigurableContentProvider;
import eu.geclipse.ui.providers.IConfigurationListener;
import eu.geclipse.ui.views.ElementManagerViewPart;
import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;

public class ViewModeAction
extends Action
implements IConfigurationListener {
    static final String VIEW_FLAT_IMAGE = "icons/obj16/view_flat.gif";
    static final String VIEW_HIERARCHICAL_IMAGE = "icons/obj16/view_hierarchical.gif";
    private ElementManagerViewPart view;
    private int viewMode;

    protected ViewModeAction(String string, int n, ElementManagerViewPart elementManagerViewPart) {
        super(string);
        this.view = elementManagerViewPart;
        this.viewMode = n;
        this.updateActionState();
        URL uRL = null;
        if (n == 1) {
            uRL = Activator.getDefault().getBundle().getEntry(VIEW_FLAT_IMAGE);
        } else if (n == 2) {
            uRL = Activator.getDefault().getBundle().getEntry(VIEW_HIERARCHICAL_IMAGE);
        }
        if (uRL != null) {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
            this.setImageDescriptor(imageDescriptor);
        }
    }

    public void configurationChanged(ConfigurableContentProvider configurableContentProvider) {
        if (configurableContentProvider == this.getContentProvider()) {
            this.updateActionState();
        }
    }

    public void run() {
        ConfigurableContentProvider configurableContentProvider = this.getContentProvider();
        if (configurableContentProvider != null) {
            configurableContentProvider.setMode(this.viewMode);
            this.view.refreshViewer();
        }
        this.updateActionState();
    }

    public ConfigurableContentProvider getContentProvider() {
        StructuredViewer structuredViewer = this.view.getViewer();
        ConfigurableContentProvider configurableContentProvider = null;
        IContentProvider iContentProvider = structuredViewer.getContentProvider();
        if (iContentProvider instanceof ConfigurableContentProvider) {
            configurableContentProvider = (ConfigurableContentProvider)iContentProvider;
        }
        return configurableContentProvider;
    }

    protected int getProviderMode() {
        int n = 0;
        ConfigurableContentProvider configurableContentProvider = this.getContentProvider();
        if (configurableContentProvider != null) {
            n = configurableContentProvider.getMode();
        }
        return n;
    }

    protected void updateActionState() {
        int n = this.getProviderMode();
        this.setChecked(n == this.viewMode);
    }
}

