/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.dialogs.ConfigureFilters;

import eu.geclipse.ui.internal.dialogs.ConfigureFilters.IFilterComposite;
import eu.geclipse.ui.internal.dialogs.ConfigureFilters.Messages;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import eu.geclipse.ui.views.filters.JobStatusFilter;
import eu.geclipse.ui.views.filters.JobViewFilterConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JobStatusComposite
implements IFilterComposite {
    private JobStatusFilter filter;
    private List<StatusOption> optionsList = new ArrayList<StatusOption>();
    private Group topGroup;
    private boolean enabled = true;

    public JobStatusComposite(JobStatusFilter jobStatusFilter, Composite composite) {
        this.filter = jobStatusFilter;
        this.topGroup = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        this.topGroup.setLayout((Layout)gridLayout);
        this.topGroup.setLayoutData((Object)new GridData(4, 128, false, false));
        Label label = new Label((Composite)this.topGroup, 0);
        label.setText(Messages.getString("JobStatusComposite.Description"));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.submitted"), 1));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.waiting"), 2));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.running"), 4));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.done"), 8));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.aborted"), 16));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.purged"), 32));
        this.optionsList.add(new StatusOption((Composite)this.topGroup, Messages.getString("JobStatusComposite.others"), 128));
        this.refresh();
    }

    public boolean saveToFilter() {
        if (this.filter != null) {
            for (StatusOption statusOption : this.optionsList) {
                this.filter.setStatusState(statusOption.getStatusValue(), statusOption.isSelected());
            }
        }
        return true;
    }

    public void setFilter(IGridFilterConfiguration iGridFilterConfiguration) {
        this.filter = iGridFilterConfiguration == null ? null : ((JobViewFilterConfiguration)iGridFilterConfiguration).getJobStatusFilter();
        this.refresh();
    }

    private void refresh() {
        if (this.filter != null) {
            for (StatusOption statusOption : this.optionsList) {
                statusOption.setSelected(this.filter.getStatusState(statusOption.getStatusValue()));
            }
            this.onChangeEnabledState();
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.onChangeEnabledState();
    }

    void onChangeEnabledState() {
        for (StatusOption statusOption : this.optionsList) {
            statusOption.setEnabled(this.enabled);
        }
    }

    private class StatusOption {
        private int statusValue;
        private Button checkbox;

        StatusOption(Composite composite, String string, int n) {
            this.statusValue = n;
            this.checkbox = new Button(composite, 32);
            this.checkbox.setText(string);
        }

        void setSelected(boolean bl) {
            this.checkbox.setSelection(bl);
        }

        boolean isSelected() {
            return this.checkbox.getSelection();
        }

        void enable(boolean bl) {
            this.checkbox.setEnabled(bl);
        }

        int getStatusValue() {
            return this.statusValue;
        }

        void setEnabled(boolean bl) {
            this.checkbox.setEnabled(bl);
        }
    }
}

