/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.dialogs.ConfigureFilters;

import eu.geclipse.core.GridException;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.internal.dialogs.ConfigureFilters.IFilterComposite;
import eu.geclipse.ui.internal.dialogs.ConfigureFilters.Messages;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import eu.geclipse.ui.views.filters.JobSubmissionTimeFilter;
import eu.geclipse.ui.views.filters.JobViewFilterConfiguration;
import eu.geclipse.ui.widgets.DateTimeText;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JobSubmissionTimeComposite
implements IFilterComposite {
    private JobSubmissionTimeFilter filter;
    private DateTimeText afterDateTimeText;
    private DateTimeText beforeDateTimeText;
    private Composite parent;

    public JobSubmissionTimeComposite(JobSubmissionTimeFilter jobSubmissionTimeFilter, Composite composite) {
        this.filter = jobSubmissionTimeFilter;
        this.parent = composite;
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 4, false, false));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.getString("JobSubmissionTimeComposite.afterDateDescription"));
        this.afterDateTimeText = new DateTimeText((Composite)group, DateTimeText.Style.DATETIME, true);
        label = new Label((Composite)group, 0);
        label.setText(Messages.getString("JobSubmissionTimeComposite.beforeDateDescription"));
        this.beforeDateTimeText = new DateTimeText((Composite)group, DateTimeText.Style.DATETIME, true);
        this.refresh();
    }

    public boolean saveToFilter() {
        boolean bl = false;
        if (this.filter != null) {
            try {
                Date date = this.afterDateTimeText.getDate();
                try {
                    Date date2 = this.beforeDateTimeText.getDate();
                    this.filter.setDates(date, date2);
                    bl = true;
                }
                catch (GridException gridException) {
                    this.beforeDateTimeText.setFocus();
                    NewProblemDialog.openProblem(this.parent.getShell(), Messages.getString("JobSubmissionTimeComposite.ErrTitle"), Messages.getString("JobSubmissionTimeComposite.ErrSavingBeforeDate"), gridException);
                }
            }
            catch (GridException gridException) {
                this.afterDateTimeText.setFocus();
                NewProblemDialog.openProblem(this.parent.getShell(), Messages.getString("JobSubmissionTimeComposite.ErrTitle"), Messages.getString("JobSubmissionTimeComposite.ErrSavingAfterDate"), gridException);
            }
        }
        return bl;
    }

    public void setFilter(IGridFilterConfiguration iGridFilterConfiguration) {
        if (iGridFilterConfiguration != null) {
            this.filter = ((JobViewFilterConfiguration)iGridFilterConfiguration).getSubmissionTimeFilter();
        }
        this.refresh();
    }

    private void refresh() {
        Date date = null;
        Date date2 = null;
        if (this.filter != null) {
            date = this.filter.getAfterDate();
            date2 = this.filter.getBeforeDate();
        }
        this.afterDateTimeText.setDate(date);
        this.beforeDateTimeText.setDate(date2);
    }

    public void setEnabled(boolean bl) {
        this.afterDateTimeText.setEnabled(bl);
        this.beforeDateTimeText.setEnabled(bl);
    }
}

