/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.preference;

import eu.geclipse.core.auth.CaCertManager;
import eu.geclipse.core.auth.ICaCertificate;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.preference.Messages;
import eu.geclipse.ui.internal.wizards.CaCertificateImportWizard;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CaCertPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IContentChangeListener {
    protected List caList;
    protected Button deleteButton;
    private Button addFromDirButton;
    private Button addFromRepoButton;

    public CaCertPreferencePage() {
        this.setDescription(Messages.getString("CaCertPreferencePage.description"));
        CaCertManager.getManager().addContentChangeListener((IContentChangeListener)this);
    }

    public void contentChanged(IContentChangeNotifier iContentChangeNotifier) {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                CaCertPreferencePage.this.updateCaList();
            }
        });
    }

    public void dispose() {
        CaCertManager.getManager().removeContentChangeListener((IContentChangeListener)this);
        super.dispose();
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.noDefaultAndApplyButton();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("CaCertPreferencePage.list_label"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.caList = new List(composite2, 2562);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 100;
        gridData.heightHint = 150;
        this.caList.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        this.addFromRepoButton = new Button(composite3, 8);
        this.addFromRepoButton.setText(Messages.getString("CaCertPreferencePage.add_rep_button"));
        gridData = new GridData(768);
        this.addFromRepoButton.setLayoutData((Object)gridData);
        this.addFromDirButton = new Button(composite3, 8);
        this.addFromDirButton.setText(Messages.getString("CaCertPreferencePage.add_dir_button"));
        gridData = new GridData(768);
        this.addFromDirButton.setLayoutData((Object)gridData);
        Label label2 = new Label(composite3, 0);
        label2.setVisible(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 4;
        label2.setLayoutData((Object)gridData);
        this.deleteButton = new Button(composite3, 8);
        this.deleteButton.setText(Messages.getString("CaCertPreferencePage.delete_button"));
        gridData = new GridData(768);
        this.deleteButton.setLayoutData((Object)gridData);
        this.deleteButton.setEnabled(false);
        this.caList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = CaCertPreferencePage.this.caList.getSelectionCount();
                CaCertPreferencePage.this.deleteButton.setEnabled(n > 0);
            }
        });
        this.caList.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 127) {
                    CaCertPreferencePage.this.deleteSelected();
                }
            }
        });
        this.addFromDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CaCertPreferencePage.this.addFromDirectory();
            }
        });
        this.addFromRepoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CaCertPreferencePage.this.addFromRepository();
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CaCertPreferencePage.this.deleteSelected();
            }
        });
        this.updateCaList();
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void updateCaList() {
        this.caList.removeAll();
        CaCertManager caCertManager = CaCertManager.getManager();
        ICaCertificate[] iCaCertificateArray = caCertManager.getCertificates();
        Arrays.sort(iCaCertificateArray, new Comparator<ICaCertificate>(){

            @Override
            public int compare(ICaCertificate iCaCertificate, ICaCertificate iCaCertificate2) {
                return iCaCertificate.getID().compareTo(iCaCertificate2.getID());
            }
        });
        ICaCertificate[] iCaCertificateArray2 = iCaCertificateArray;
        int n = iCaCertificateArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICaCertificate iCaCertificate = iCaCertificateArray2[n2];
            this.caList.add(iCaCertificate.getID());
            ++n2;
        }
        this.deleteButton.setEnabled(this.caList.getSelectionCount() > 0);
    }

    protected void addFromDirectory() {
        this.addCertificates(CaCertificateImportWizard.ImportMethod.LOCAL);
    }

    protected void addFromRepository() {
        this.addCertificates(CaCertificateImportWizard.ImportMethod.REMOTE);
    }

    protected void deleteSelected() {
        boolean bl;
        String[] stringArray = this.caList.getSelection();
        if (stringArray.length > 0 && (bl = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("CaCertPreferencePage.confirm_delete_title"), (String)Messages.getString("CaCertPreferencePage.confirm_delete_message")))) {
            CaCertManager caCertManager = CaCertManager.getManager();
            caCertManager.deleteCertificates(stringArray);
        }
    }

    private void addCertificates(CaCertificateImportWizard.ImportMethod importMethod) {
        CaCertificateImportWizard caCertificateImportWizard = new CaCertificateImportWizard(importMethod);
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)caCertificateImportWizard);
        wizardDialog.open();
    }
}

