/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.preference;

import eu.geclipse.core.GridException;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IVoManager;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.preference.Messages;
import eu.geclipse.ui.wizards.wizardselection.ExtPointWizardSelectionListPage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IGridModelListener {
    CheckboxTableViewer voViewer;
    private Button addButton;
    private Button removeButton;
    private Button editButton;

    public VoPreferencePage() {
        this.setDescription(Messages.getString("VoPreferencePage.description"));
    }

    public void dispose() {
        GridModel.getVoManager().removeGridModelListener((IGridModelListener)this);
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.noDefaultAndApplyButton();
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("VoPreferencePage.vo_list_label"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Table table = new Table(composite, 67618);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 200;
        gridData.heightHint = 100;
        table.setLayoutData((Object)gridData);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                IVirtualOrganization iVirtualOrganization = VoPreferencePage.this.getSelectedVo();
                if (iVirtualOrganization != null) {
                    VoPreferencePage.this.editVO(iVirtualOrganization);
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
                    VoPreferencePage.this.removeSelectedVOs();
                }
            }
        });
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(Messages.getString("VoPreferencePage.name_column_text"));
        tableColumn.setWidth(100);
        TableColumn tableColumn2 = new TableColumn(table, 0x1000000);
        tableColumn2.setText(Messages.getString("VoPreferencePage.type_column_text"));
        tableColumn2.setWidth(100);
        final IVoManager iVoManager = GridModel.getVoManager();
        this.voViewer = new CheckboxTableViewer(table);
        this.voViewer.setLabelProvider((IBaseLabelProvider)new VoLabelProvider());
        this.voViewer.setContentProvider((IContentProvider)new VoContentProvider());
        this.voViewer.setInput((Object)iVoManager);
        this.voViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                VoPreferencePage.this.updateButtons();
            }
        });
        iVoManager.addGridModelListener((IGridModelListener)this);
        IVirtualOrganization iVirtualOrganization = (IVirtualOrganization)iVoManager.getDefault();
        if (iVirtualOrganization != null) {
            this.voViewer.setCheckedElements(new Object[]{iVirtualOrganization});
        }
        this.voViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Object object = checkStateChangedEvent.getElement();
                if (object instanceof IVirtualOrganization) {
                    IVirtualOrganization iVirtualOrganization = (IVirtualOrganization)object;
                    try {
                        if (!checkStateChangedEvent.getChecked()) {
                            iVoManager.setDefault(null);
                        } else {
                            VoPreferencePage.this.voViewer.setCheckedElements(new Object[]{iVirtualOrganization});
                            VoPreferencePage.this.voViewer.refresh();
                            iVoManager.setDefault((IGridElement)iVirtualOrganization);
                        }
                    }
                    catch (GridModelException gridModelException) {
                        Activator.logException(gridModelException);
                    }
                }
            }
        });
        Composite composite2 = new Composite(composite, 0);
        gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout2);
        this.addButton = new Button(composite2, 8);
        this.addButton.setText(Messages.getString("VoPreferencePage.add_button"));
        gridData = new GridData(768);
        this.addButton.setLayoutData((Object)gridData);
        this.editButton = new Button(composite2, 8);
        this.editButton.setText(Messages.getString("VoPreferencePage.edit_button"));
        gridData = new GridData(768);
        this.editButton.setLayoutData((Object)gridData);
        this.removeButton = new Button(composite2, 8);
        this.removeButton.setText(Messages.getString("VoPreferencePage.remove_button"));
        gridData = new GridData(768);
        this.removeButton.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 0);
        label2.setVisible(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 4;
        label2.setLayoutData((Object)gridData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VoPreferencePage.this.editVO(null);
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IVirtualOrganization iVirtualOrganization = VoPreferencePage.this.getSelectedVo();
                if (iVirtualOrganization != null) {
                    VoPreferencePage.this.editVO(iVirtualOrganization);
                }
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VoPreferencePage.this.removeSelectedVOs();
            }
        });
        this.updateButtons();
        return composite;
    }

    public IVirtualOrganization getSelectedVo() {
        IVirtualOrganization iVirtualOrganization = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.voViewer.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IVirtualOrganization) {
            iVirtualOrganization = (IVirtualOrganization)object;
        }
        return iVirtualOrganization;
    }

    public List<IVirtualOrganization> getSelectedVos() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.voViewer.getSelection();
        List list = iStructuredSelection.toList();
        ArrayList<IVirtualOrganization> arrayList = new ArrayList<IVirtualOrganization>();
        for (Object e : list) {
            if (!(e instanceof IVirtualOrganization)) continue;
            IVirtualOrganization iVirtualOrganization = (IVirtualOrganization)e;
            arrayList.add(iVirtualOrganization);
        }
        return arrayList;
    }

    public void editVO(final IVirtualOrganization iVirtualOrganization) {
        URL uRL = Activator.getDefault().getBundle().getEntry("icons/wizban/vo_wiz.gif");
        Wizard wizard = new Wizard(){

            public void addPages() {
                ExtPointWizardSelectionListPage extPointWizardSelectionListPage = new ExtPointWizardSelectionListPage("pagename", "eu.geclipse.ui.newVoWizards", Messages.getString("VoPreferencePage.create_new_vo"), Messages.getString("VoPreferencePage.create_new_vo_long"), Messages.getString("VoPreferencePage.no_vo_providers"));
                extPointWizardSelectionListPage.setInitData(iVirtualOrganization);
                if (iVirtualOrganization != null) {
                    extPointWizardSelectionListPage.setPreselectedId(iVirtualOrganization.getWizardId(), true);
                }
                this.addPage((IWizardPage)extPointWizardSelectionListPage);
            }

            public boolean performFinish() {
                return false;
            }
        };
        wizard.setForcePreviousAndNextButtons(true);
        wizard.setNeedsProgressMonitor(true);
        wizard.setWindowTitle(Messages.getString("VoPreferencePage.create_new_vo"));
        wizard.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)uRL));
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        wizardDialog.open();
    }

    public void removeSelectedVOs() {
        List<IVirtualOrganization> list = this.getSelectedVos();
        if (!list.isEmpty()) {
            boolean bl;
            boolean bl2 = bl = !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("VoPreferencePage.delete_vos"), (String)Messages.getString("VoPreferencePage.really_delete_vos"));
            if (!bl) {
                IGridElement[] iGridElementArray = new IGridElement[]{};
                try {
                    iGridElementArray = GridModel.getRoot().getChildren(null);
                }
                catch (GridModelException gridModelException) {}
                IVoManager iVoManager = GridModel.getVoManager();
                IGridProject iGridProject = null;
                for (IVirtualOrganization iVirtualOrganization : list) {
                    boolean bl3 = false;
                    IGridElement[] iGridElementArray2 = iGridElementArray;
                    int n = iGridElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IGridElement iGridElement = iGridElementArray2[n2];
                        iGridProject = (IGridProject)iGridElement;
                        if (iGridProject.isGridProject() && iVirtualOrganization == iGridProject.getVO()) {
                            bl3 = true;
                            break;
                        }
                        ++n2;
                    }
                    if (bl3) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("VoPreferencePage.error"), (String)String.format(Messages.getString("VoPreferencePage.vo_in_use"), iVirtualOrganization.getName(), iGridProject.getName()));
                        continue;
                    }
                    try {
                        iVoManager.delete((IGridElement)iVirtualOrganization);
                    }
                    catch (GridModelException gridModelException) {
                        NewProblemDialog.openProblem(this.getShell(), Messages.getString("VoPreferencePage.error"), String.valueOf(Messages.getString("VoPreferencePage.delete_vo_failed")) + " " + iVirtualOrganization.getName(), (GridException)((Object)gridModelException), null);
                    }
                }
                this.updateButtons();
            }
        }
    }

    protected void updateButtons() {
        ISelection iSelection = this.voViewer.getSelection();
        boolean bl = !iSelection.isEmpty();
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(bl);
        this.editButton.setEnabled(bl);
    }

    public void gridModelChanged(IGridModelEvent iGridModelEvent) {
        this.voViewer.refresh();
        IVoManager iVoManager = GridModel.getVoManager();
        IGridElement iGridElement = iVoManager.getDefault();
        if (iGridElement != null) {
            this.voViewer.setCheckedElements(new Object[]{iGridElement});
        }
        this.updateButtons();
    }

    public boolean performOk() {
        try {
            GridModel.getVoManager().saveElements();
        }
        catch (GridModelException gridModelException) {
            Activator.logException(gridModelException);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        try {
            GridModel.getVoManager().loadElements();
        }
        catch (GridModelException gridModelException) {
            Activator.logException(gridModelException);
        }
        super.performDefaults();
    }

    class VoContentProvider
    implements IStructuredContentProvider {
        private Shell shell;

        VoContentProvider() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = null;
            if (object instanceof IVoManager) {
                IVoManager iVoManager = (IVoManager)object;
                try {
                    objectArray = iVoManager.getChildren(null);
                    Arrays.sort(objectArray, new Comparator<IGridElement>(){

                        @Override
                        public int compare(IGridElement iGridElement, IGridElement iGridElement2) {
                            return iGridElement.getName().compareTo(iGridElement2.getName());
                        }
                    });
                }
                catch (GridModelException gridModelException) {
                    if (this.shell != null) {
                        NewProblemDialog.openProblem(this.shell, Messages.getString("VoPreferencePage.content_provider_problem"), Messages.getString("VoPreferencePage.query_vo_failed"), gridModelException);
                    }
                    Activator.logException(gridModelException);
                }
            }
            return objectArray;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (viewer != null) {
                this.shell = viewer.getControl().getShell();
            }
        }
    }

    class VoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        VoLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            String string = null;
            if (object instanceof IVirtualOrganization) {
                switch (n) {
                    case 0: {
                        string = ((IVirtualOrganization)object).getName();
                        break;
                    }
                    case 1: {
                        string = ((IVirtualOrganization)object).getTypeName();
                    }
                }
            }
            return string;
        }
    }
}

