/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.transfer;

import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.transfer.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class GridElementTransferOperation
extends Job {
    private IGridContainer globalTarget;
    private IGridElement[] elements;
    private boolean move;

    public GridElementTransferOperation(IGridElement[] iGridElementArray, IGridContainer iGridContainer, boolean bl) {
        super(Messages.getString("GridElementTransferOperation.transfer_name"));
        this.globalTarget = iGridContainer;
        this.elements = iGridElementArray;
        this.move = bl;
    }

    public IGridElement[] getElements() {
        return this.elements;
    }

    public IGridContainer getTarget() {
        return this.globalTarget;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) {
        IProgressMonitor iProgressMonitor2 = iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor;
        MultiStatus multiStatus = new MultiStatus("eu.geclipse.ui", 0, Messages.getString("GridElementTransferOperation.op_status"), null);
        iProgressMonitor2.beginTask(Messages.getString("GridElementTransferOperation.transfering_element_progress"), this.elements.length);
        IGridElement[] iGridElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement iGridElement = iGridElementArray[n2];
            iProgressMonitor2.subTask(iGridElement.getName());
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor2, 1);
            IStatus iStatus = this.transferElement(iGridElement, this.globalTarget, (IProgressMonitor)subProgressMonitor);
            if (!iStatus.isOK()) {
                multiStatus.merge(iStatus);
            }
            if (iProgressMonitor2.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
        return multiStatus;
    }

    private IStatus copy(IFileStore iFileStore, IFileStore iFileStore2, IProgressMonitor iProgressMonitor) {
        IStatus iStatus = Status.OK_STATUS;
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        iStatus = iFileInfo.isDirectory() ? this.copyDirectory(iFileStore, iFileStore2, iProgressMonitor) : this.copyFile(iFileStore, iFileStore2, iProgressMonitor);
        return iStatus;
    }

    private IStatus copyDirectory(IFileStore iFileStore, IFileStore iFileStore2, IProgressMonitor iProgressMonitor) {
        IStatus iStatus;
        block12: {
            iStatus = Status.OK_STATUS;
            iProgressMonitor.beginTask(String.valueOf(Messages.getString("GridElementTransferOperation.copying_progress")) + iFileStore.getName(), 10);
            try {
                IFileStore[] iFileStoreArray = null;
                try {
                    iFileStoreArray = iFileStore.childStores(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                catch (CoreException coreException) {
                    iStatus = new Status(4, "eu.geclipse.ui", 0, String.valueOf(Messages.getString("GridElementTransferOperation.fetching_children_error")) + iFileStore.getName(), (Throwable)coreException);
                }
                if (!iStatus.isOK() || iFileStoreArray == null) break block12;
                IFileStore iFileStore3 = iFileStore2.getChild(iFileStore.getName());
                IFileInfo iFileInfo = iFileStore3.fetchInfo();
                boolean bl = !iFileInfo.exists();
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 9);
                subProgressMonitor.beginTask(String.valueOf(Messages.getString("GridElementTransferOperation.copying_progress")) + iFileStore.getName(), bl ? iFileStoreArray.length + 1 : iFileStoreArray.length);
                if (bl) {
                    try {
                        iFileStore3.mkdir(0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                    }
                    catch (CoreException coreException) {
                        iStatus = new Status(4, "eu.geclipse.ui", 0, String.valueOf(Messages.getString("GridElementTransferOperation.create_dir_error")) + iFileStore3.getName(), (Throwable)coreException);
                    }
                }
                if (iStatus.isOK()) {
                    MultiStatus multiStatus = new MultiStatus("eu.geclipse.ui", 0, String.valueOf(Messages.getString("GridElementTransferOperation.copying_members_status")) + iFileStore.getName(), null);
                    IFileStore[] iFileStoreArray2 = iFileStoreArray;
                    int n = iFileStoreArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFileStore iFileStore4 = iFileStoreArray2[n2];
                        IStatus iStatus2 = this.copy(iFileStore4, iFileStore3, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                        if (!iStatus2.isOK()) {
                            multiStatus.merge(iStatus2);
                        }
                        if (subProgressMonitor.isCanceled()) break;
                        ++n2;
                    }
                    if (!multiStatus.isOK()) {
                        iStatus = multiStatus;
                    }
                }
            }
            finally {
                iProgressMonitor.done();
            }
        }
        return iStatus;
    }

    private IStatus copyFile(IFileStore iFileStore, IFileStore iFileStore2, IProgressMonitor iProgressMonitor) {
        IStatus iStatus;
        OutputStream outputStream;
        InputStream inputStream;
        block26: {
            iProgressMonitor.beginTask(String.valueOf(Messages.getString("GridElementTransferOperation.copying_progress")) + iFileStore.getName(), 100);
            iProgressMonitor.setTaskName(String.valueOf(Messages.getString("GridElementTransferOperation.copying_progress")) + iFileStore.getName());
            inputStream = null;
            outputStream = null;
            iStatus = Status.OK_STATUS;
            try {
                IFileInfo iFileInfo = iFileStore.fetchInfo();
                long l = iFileInfo.getLength();
                IFileStore iFileStore3 = iFileStore2.getChild(iFileStore.getName());
                IFileInfo iFileInfo2 = iFileStore3.fetchInfo();
                if (iFileInfo2.exists()) {
                    iStatus = new Status(4, "eu.geclipse.ui", 0, String.format(Messages.getString("GridElementTransferOperation.unable_to_transfer_file"), iFileStore3.getName(), iFileStore2.getName()), null);
                }
                if (iStatus.isOK()) {
                    try {
                        inputStream = iFileStore.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 8));
                    }
                    catch (CoreException coreException) {
                        iStatus = new Status(4, "eu.geclipse.ui", 0, String.format(Messages.getString("GridElementTransferOperation.unable_to_open_istream"), iFileStore.getName()), (Throwable)coreException);
                    }
                }
                if (iStatus.isOK()) {
                    try {
                        outputStream = iFileStore3.openOutputStream(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 8));
                    }
                    catch (CoreException coreException) {
                        iStatus = new Status(4, "eu.geclipse.ui", 0, String.format(Messages.getString("GridElementTransferOperation.unable_to_open_ostream"), iFileStore3.getName()), (Throwable)coreException);
                    }
                }
                if (!iStatus.isOK() || inputStream == null || outputStream == null) break block26;
                byte[] byArray = new byte[1024];
                Integer n = new Integer((int)Math.ceil((double)l / (double)byArray.length));
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 85);
                subProgressMonitor.beginTask(String.valueOf(Messages.getString("GridElementTransferOperation.copying_progress")) + iFileStore.getName(), n.intValue());
                subProgressMonitor.subTask(String.valueOf(Messages.getString("GridElementTransferOperation.copying_progress")) + iFileStore.getName());
                int n2 = 0;
                while (!subProgressMonitor.isCanceled() && iStatus.isOK()) {
                    int n3 = -1;
                    try {
                        n3 = inputStream.read(byArray);
                    }
                    catch (IOException iOException) {
                        iStatus = new Status(4, "eu.geclipse.ui", 0, String.format(Messages.getString("GridElementTransferOperation.reading_error"), iFileStore.getName()), (Throwable)iOException);
                    }
                    if (n3 == -1) break;
                    try {
                        outputStream.write(byArray, 0, n3);
                    }
                    catch (IOException iOException) {
                        iStatus = new Status(4, "eu.geclipse.ui", 0, String.format(Messages.getString("GridElementTransferOperation.writing_error"), iFileStore3.getName()), (Throwable)iOException);
                    }
                    subProgressMonitor.worked(1);
                    subProgressMonitor.subTask(String.format(Messages.getString("GridElementTransferOperation.transfer_progress_format"), iFileInfo.getName(), new Integer((int)((long)(100 * ((++n2 - 1) * byArray.length + n3)) / l)), new Integer(n2), n));
                }
                subProgressMonitor.done();
            }
            catch (Throwable throwable) {
                iProgressMonitor.subTask(Messages.getString("GridElementTransferOperation.closing_streams"));
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                iProgressMonitor.done();
                throw throwable;
            }
        }
        iProgressMonitor.subTask(Messages.getString("GridElementTransferOperation.closing_streams"));
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        iProgressMonitor.done();
        return iStatus;
    }

    private IStatus delete(IFileStore iFileStore, IProgressMonitor iProgressMonitor) {
        IStatus iStatus = Status.OK_STATUS;
        try {
            iFileStore.delete(0, iProgressMonitor);
        }
        catch (CoreException coreException) {
            iStatus = new Status(4, "eu.geclipse.ui", 0, String.valueOf(Messages.getString("GridElementTransferOperation.deletion_error")) + iFileStore.getName(), (Throwable)coreException);
        }
        return iStatus;
    }

    private IStatus transferElement(IGridElement iGridElement, IGridContainer iGridContainer, IProgressMonitor iProgressMonitor) {
        IStatus iStatus;
        block15: {
            iStatus = Status.OK_STATUS;
            IFileStore iFileStore = null;
            IFileStore iFileStore2 = null;
            try {
                iFileStore = this.getFileStore(iGridElement);
            }
            catch (CoreException coreException) {
                iStatus = new Status(4, "eu.geclipse.ui", 0, String.format(Messages.getString("GridElementTransferOperation.unable_get_filestore"), iGridElement.getName()), (Throwable)coreException);
            }
            if (iStatus.isOK()) {
                try {
                    iFileStore2 = this.getFileStore((IGridElement)iGridContainer);
                }
                catch (CoreException coreException) {
                    iStatus = new Status(4, "eu.geclipse.ui", 0, String.format(Messages.getString("GridElementTransferOperation.unable_get_filestore"), iGridContainer.getName()), (Throwable)coreException);
                }
            }
            if (iStatus.isOK()) {
                iProgressMonitor.beginTask(String.valueOf(Messages.getString("GridElementTransferOperation.transfering_progress")) + iGridElement.getName(), 10);
                try {
                    SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, this.move ? 5 : 9);
                    iStatus = this.copy(iFileStore, iFileStore2, (IProgressMonitor)subProgressMonitor);
                    if (!iStatus.isOK()) break block15;
                    try {
                        iGridContainer.refresh((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    catch (GridModelException gridModelException) {
                        Activator.logException(gridModelException);
                    }
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (this.move && (iStatus = this.delete(iFileStore, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3))).isOK()) {
                        try {
                            iGridElement.getParent().refresh((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        }
                        catch (GridModelException gridModelException) {
                            Activator.logException(gridModelException);
                        }
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        }
        return iStatus;
    }

    private IFileStore getFileStore(IGridElement iGridElement) throws CoreException {
        IFileStore iFileStore = null;
        iFileStore = iGridElement instanceof IGridConnectionElement ? ((IGridConnectionElement)iGridElement).getConnectionFileStore() : iGridElement.getFileStore();
        return iFileStore;
    }
}

