/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.transfer;

import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.views.GridModelViewPart;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SelectionTransferDragAdapter
implements TransferDragSourceListener {
    private GridModelViewPart view;

    public SelectionTransferDragAdapter(GridModelViewPart gridModelViewPart) {
        Assert.isNotNull((Object)((Object)gridModelViewPart));
        this.view = gridModelViewPart;
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        LocalSelectionTransfer.getInstance().setSelection(null);
        LocalSelectionTransfer.getInstance().setSelectionSetTime(0L);
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.data = LocalSelectionTransfer.getInstance().getSelection();
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        ISelection iSelection = this.view.getViewer().getSelection();
        dragSourceEvent.doit = this.isDragable(iSelection);
        if (dragSourceEvent.doit) {
            LocalSelectionTransfer.getInstance().setSelection(iSelection);
            LocalSelectionTransfer.getInstance().setSelectionSetTime((long)dragSourceEvent.time & 0xFFFFFFFFL);
        }
    }

    protected boolean isDragable(ISelection iSelection) {
        boolean bl = true;
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext() && bl) {
                Object e = iterator.next();
                if (e instanceof IGridElement && this.view.isDragSource((IGridElement)e)) continue;
                bl = false;
            }
        }
        return bl;
    }
}

