/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.transfer;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.internal.transfer.GridElementTransferOperation;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SelectionTransferDropAdapter
implements TransferDropTargetListener {
    private IGridContainer lastTarget;
    private int lastDetail;

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent dropTargetEvent) {
        IGridContainer iGridContainer = this.getTarget(dropTargetEvent);
        return iGridContainer != null;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.lastTarget = this.getTarget(dropTargetEvent);
        this.lastDetail = dropTargetEvent.detail;
        this.validateDrop(dropTargetEvent);
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        this.lastTarget = null;
        this.lastDetail = 0;
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
        this.lastDetail = dropTargetEvent.detail;
        this.validateDrop(dropTargetEvent);
        this.computeFeedback(dropTargetEvent);
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        IGridContainer iGridContainer = this.getTarget(dropTargetEvent);
        if (iGridContainer != this.lastTarget) {
            this.lastTarget = iGridContainer;
            this.validateDrop(dropTargetEvent);
        }
        this.computeFeedback(dropTargetEvent);
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        IGridContainer iGridContainer = this.getTarget(dropTargetEvent);
        IGridElement[] iGridElementArray = this.getElements();
        GridElementTransferOperation gridElementTransferOperation = null;
        switch (dropTargetEvent.detail) {
            case 1: {
                gridElementTransferOperation = new GridElementTransferOperation(iGridElementArray, iGridContainer, false);
                break;
            }
            case 2: {
                gridElementTransferOperation = new GridElementTransferOperation(iGridElementArray, iGridContainer, true);
            }
        }
        if (gridElementTransferOperation != null) {
            gridElementTransferOperation.setUser(true);
            gridElementTransferOperation.schedule();
        } else {
            dropTargetEvent.detail = 0;
        }
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        this.lastTarget = this.getTarget(dropTargetEvent);
        this.validateDrop(dropTargetEvent);
        this.lastDetail = dropTargetEvent.detail;
    }

    protected void computeFeedback(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.feedback = 25;
    }

    protected IGridElement[] getElements() {
        IGridElement[] iGridElementArray = null;
        ISelection iSelection = LocalSelectionTransfer.getInstance().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Iterator iterator = iStructuredSelection.iterator();
            ArrayList<IGridElement> arrayList = new ArrayList<IGridElement>();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof IGridElement)) continue;
                arrayList.add((IGridElement)e);
            }
            if (arrayList.size() == iStructuredSelection.size()) {
                iGridElementArray = arrayList.toArray(new IGridElement[arrayList.size()]);
            }
        }
        return iGridElementArray;
    }

    protected IGridContainer getTarget(DropTargetEvent dropTargetEvent) {
        Object object;
        IGridContainer iGridContainer = null;
        Widget widget = dropTargetEvent.item;
        if (widget != null && (object = widget.getData()) != null && object instanceof IGridContainer) {
            iGridContainer = (IGridContainer)object;
        }
        return iGridContainer;
    }

    protected void validateDrop(DropTargetEvent dropTargetEvent) {
        int n = this.computeDropOperations(dropTargetEvent);
        dropTargetEvent.detail = (n & this.lastDetail) != 0 ? this.lastDetail : ((n & 0x10) != 0 ? 16 : ((n & 2) != 0 ? 2 : ((n & 1) != 0 ? 1 : 0)));
    }

    protected int computeDropOperations(DropTargetEvent dropTargetEvent) {
        IGridElement[] iGridElementArray;
        int n = 0;
        if (this.lastTarget != null && (iGridElementArray = this.getElements()) != null && iGridElementArray.length > 0) {
            n = dropTargetEvent.operations;
            IGridElement[] iGridElementArray2 = iGridElementArray;
            int n2 = iGridElementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IGridElement iGridElement = iGridElementArray2[n3];
                if ((n &= this.computeDropOperations(this.lastTarget, iGridElement)) == 0) break;
                ++n3;
            }
        }
        return n;
    }

    protected int computeDropOperations(IGridContainer iGridContainer, IGridElement iGridElement) {
        int n = 19;
        if (iGridContainer == iGridElement || iGridContainer == iGridElement.getParent() || !iGridContainer.canContain(iGridElement)) {
            n = 0;
        } else if (!iGridContainer.isLocal() || !iGridElement.isLocal()) {
            if (!iGridContainer.isLocal() && !iGridElement.isLocal()) {
                IGridElement iGridElement2;
                IGridElement iGridElement3 = this.findLastRemoteElement((IGridElement)iGridContainer);
                if (iGridElement3 != (iGridElement2 = this.findLastRemoteElement(iGridElement))) {
                    n = 1;
                }
            } else {
                n = 1;
            }
        }
        return n;
    }

    private IGridElement findLastRemoteElement(IGridElement iGridElement) {
        IGridElement iGridElement2 = iGridElement;
        IGridContainer iGridContainer = iGridElement.getParent();
        while (iGridContainer != null && !iGridContainer.isLocal()) {
            iGridElement2 = iGridContainer;
            iGridContainer = iGridContainer.getParent();
        }
        return iGridElement2;
    }
}

