/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.GridException;
import eu.geclipse.core.auth.CaCertManager;
import eu.geclipse.core.auth.ICaCertificate;
import eu.geclipse.core.auth.ICaCertificateLoader;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.wizards.AbstractLocationChooserPage;
import eu.geclipse.ui.internal.wizards.CertificateChooserPage;
import eu.geclipse.ui.internal.wizards.CertificateLoaderSelectionPage;
import eu.geclipse.ui.internal.wizards.LocalLocationChooserPage;
import eu.geclipse.ui.internal.wizards.RemoteLocationChooserPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

public class CaCertificateImportWizard
extends Wizard {
    private ImportMethod importMethod;
    private CertificateLoaderSelectionPage selectionPage;
    private AbstractLocationChooserPage locationPage;
    private CertificateChooserPage certPage;

    public CaCertificateImportWizard(ImportMethod importMethod) {
        this.importMethod = importMethod;
        this.setNeedsProgressMonitor(true);
        URL uRL = Activator.getDefault().getBundle().getEntry("icons/wizban/cacert_wiz.gif");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)uRL));
    }

    public void addPages() {
        this.selectionPage = new CertificateLoaderSelectionPage(this.importMethod);
        this.addPage((IWizardPage)this.selectionPage);
        if (this.importMethod == ImportMethod.LOCAL) {
            this.locationPage = new LocalLocationChooserPage(this.selectionPage);
        } else if (this.importMethod == ImportMethod.REMOTE) {
            this.locationPage = new RemoteLocationChooserPage(this.selectionPage);
        }
        this.addPage((IWizardPage)this.locationPage);
        this.certPage = new CertificateChooserPage(this.locationPage);
        this.addPage((IWizardPage)this.certPage);
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.certPage;
    }

    public String getWindowTitle() {
        return "Import CA Certificates";
    }

    public boolean performFinish() {
        boolean bl = true;
        WizardPage wizardPage = (WizardPage)this.getContainer().getCurrentPage();
        wizardPage.setErrorMessage(null);
        final ICaCertificateLoader iCaCertificateLoader = this.selectionPage.getSelectedLoader();
        final URI uRI = this.locationPage.getSelectedLocation();
        final String[] stringArray = this.certPage.getSelectedCertificates();
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    ICaCertificate[] iCaCertificateArray;
                    iProgressMonitor.beginTask("Fetching certificates...", stringArray.length);
                    ArrayList<ICaCertificate> arrayList = new ArrayList<ICaCertificate>();
                    try {
                        try {
                            String[] stringArray2 = stringArray;
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                iCaCertificateArray = stringArray2[n2];
                                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                                ICaCertificate iCaCertificate = iCaCertificateLoader.getCertificate(uRI, (String)iCaCertificateArray, (IProgressMonitor)subProgressMonitor);
                                if (iCaCertificate != null) {
                                    arrayList.add(iCaCertificate);
                                }
                                ++n2;
                            }
                        }
                        catch (GridException gridException) {
                            throw new InvocationTargetException(gridException);
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                    if (!arrayList.isEmpty()) {
                        iCaCertificateArray = arrayList.toArray(new ICaCertificate[arrayList.size()]);
                        CaCertManager.getManager().addCertificates(iCaCertificateArray);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            NewProblemDialog.openProblem(this.getShell(), "Import Failed", "Unable to load certificates", throwable);
            wizardPage.setErrorMessage(throwable.getLocalizedMessage());
            bl = false;
        }
        catch (InterruptedException interruptedException) {
            wizardPage.setErrorMessage(interruptedException.getLocalizedMessage());
            bl = false;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImportMethod {
        LOCAL,
        REMOTE;

    }
}

