/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.GridException;
import eu.geclipse.core.auth.ICaCertificateLoader;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.internal.wizards.AbstractLocationChooserPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class CertificateChooserPage
extends WizardPage {
    protected CheckboxTableViewer viewer;
    private AbstractLocationChooserPage locationChooserPage;

    public CertificateChooserPage(AbstractLocationChooserPage abstractLocationChooserPage) {
        super("certificateChooserPage", "Choose Certificates", null);
        this.setDescription("Choose the Certificates you would like to import");
        this.locationChooserPage = abstractLocationChooserPage;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        Table table = new Table(composite2, 2848);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(3, false));
        gridData = new GridData();
        composite3.setLayoutData((Object)gridData);
        Button button = new Button(composite3, 8);
        button.setText("Select All");
        gridData = new GridData();
        button.setLayoutData((Object)gridData);
        Button button2 = new Button(composite3, 8);
        button2.setText("Deselect All");
        gridData = new GridData();
        button2.setLayoutData((Object)gridData);
        Button button3 = new Button(composite3, 8);
        button3.setText("Revert Selection");
        gridData = new GridData();
        button3.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CertificateChooserPage.this.selectAll();
            }
        });
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CertificateChooserPage.this.deselectAll();
            }
        });
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CertificateChooserPage.this.revertSelection();
            }
        });
        this.setControl((Control)composite2);
    }

    public String[] getSelectedCertificates() {
        String[] stringArray = null;
        Object[] objectArray = this.viewer.getCheckedElements();
        if (objectArray != null) {
            stringArray = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                stringArray[n] = (String)objectArray[n];
                ++n;
            }
        }
        return stringArray;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.loadCertificateList();
        }
    }

    protected void selectAll() {
        this.viewer.setAllChecked(true);
    }

    protected void deselectAll() {
        this.viewer.setAllChecked(false);
    }

    protected void revertSelection() {
        String[] stringArray;
        String[] stringArray2 = stringArray = (String[])this.viewer.getInput();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            boolean bl = this.viewer.getChecked((Object)(string = stringArray2[n2]));
            this.viewer.setChecked((Object)string, !bl);
            ++n2;
        }
    }

    private void loadCertificateList() {
        final ICaCertificateLoader iCaCertificateLoader = this.locationChooserPage.getLoader();
        final URI uRI = this.locationChooserPage.getSelectedLocation();
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        String[] stringArray = iCaCertificateLoader.getCertificateList(uRI, iProgressMonitor);
                        CertificateChooserPage.this.viewer.setInput((Object)stringArray);
                    }
                    catch (GridException gridException) {
                        throw new InvocationTargetException(gridException);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            NewProblemDialog.openProblem(this.getShell(), "Import Failed", "Unable to load certificate list", throwable);
            this.setErrorMessage(throwable.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {}
    }
}

