/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.ui.internal.wizards.AbstractLocationChooserPage;
import eu.geclipse.ui.internal.wizards.CertificateLoaderSelectionPage;
import eu.geclipse.ui.widgets.StoredCombo;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class LocalLocationChooserPage
extends AbstractLocationChooserPage {
    protected StoredCombo combo;

    public LocalLocationChooserPage(CertificateLoaderSelectionPage certificateLoaderSelectionPage) {
        super("localLocationChooserPage", "Import Location", null, certificateLoaderSelectionPage);
        this.setDescription("Choose the local location from which you want to import certificates");
    }

    public void createControl(Composite composite) {
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        Image image = iSharedImages.getImage("IMG_OBJ_FILE");
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText("Local File or Directory:");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.combo = new StoredCombo(composite2, 0);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData(gridData);
        Button button = new Button(composite2, 8);
        button.setImage(image);
        gridData = new GridData();
        button.setLayoutData((Object)gridData);
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LocalLocationChooserPage.this.validatePage();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = LocalLocationChooserPage.this.openDirectoryDialog();
                if (string != null) {
                    LocalLocationChooserPage.this.combo.setText(string);
                }
            }
        });
        this.validatePage();
        this.setControl((Control)composite2);
    }

    public URI getSelectedLocation() {
        String string = this.combo.getText();
        Path path = new Path(string);
        IFileSystem iFileSystem = EFS.getLocalFileSystem();
        IFileStore iFileStore = iFileSystem.getStore((IPath)path);
        return iFileStore.toURI();
    }

    protected String openDirectoryDialog() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 4096);
        String string = directoryDialog.open();
        return string;
    }

    protected void validatePage() {
        String string = null;
        String string2 = this.combo.getText();
        if (string2 != null && string2.length() != 0) {
            File file = new File(string2);
            if (!file.exists()) {
                string = "No file or directory found at the specified location";
            }
        } else {
            string = "Please specify a valid file or directory";
        }
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }
}

