/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.auth.ICaCertificateLoader;
import eu.geclipse.ui.internal.wizards.AbstractLocationChooserPage;
import eu.geclipse.ui.internal.wizards.CertificateLoaderSelectionPage;
import eu.geclipse.ui.widgets.StoredCombo;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RemoteLocationChooserPage
extends AbstractLocationChooserPage {
    private StoredCombo combo;

    public RemoteLocationChooserPage(CertificateLoaderSelectionPage certificateLoaderSelectionPage) {
        super("remoteLocationChooserPage", "Import Location", null, certificateLoaderSelectionPage);
        this.setDescription("Choose the remote location from which you want to import certificates");
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText("Remote Repository URL:");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.combo = new StoredCombo(composite2, 0);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData(gridData);
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RemoteLocationChooserPage.this.validatePage();
            }
        });
        this.validatePage();
        this.setControl((Control)composite2);
    }

    public URI getSelectedLocation() {
        URI uRI = null;
        String string = this.combo.getText();
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return uRI;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.populateLocationCombo();
        }
        super.setVisible(bl);
    }

    protected void validatePage() {
        String string = null;
        String string2 = this.combo.getText();
        if (string2 != null && string2.length() != 0) {
            try {
                new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                string = String.format("Invalid URL -> %1$s", malformedURLException.getLocalizedMessage());
            }
        } else {
            string = "Please specify a valid URL";
        }
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    private void populateLocationCombo() {
        URI[] uRIArray;
        ICaCertificateLoader iCaCertificateLoader = this.getLoader();
        if (iCaCertificateLoader != null && (uRIArray = iCaCertificateLoader.getPredefinedRemoteLocations()) != null) {
            URI[] uRIArray2 = uRIArray;
            int n = uRIArray.length;
            int n2 = 0;
            while (n2 < n) {
                URI uRI = uRIArray2[n2];
                if (this.combo.getText() == null || this.combo.getText().length() == 0) {
                    this.combo.setText(uRI.toString());
                }
                this.combo.add(uRI.toString());
                ++n2;
            }
        }
    }
}

