/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertySource<ESourceType> {
    private ESourceType sourceObject;
    private List<AbstractPropertySource<?>> childPropSourceList = new LinkedList();

    public AbstractPropertySource(ESourceType ESourceType) {
        this.sourceObject = ESourceType;
    }

    protected abstract Class<? extends AbstractPropertySource<?>> getPropertySourceClass();

    protected abstract List<IProperty<ESourceType>> getStaticProperties();

    public List<IPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> arrayList = new ArrayList<IPropertyDescriptor>();
        this.appendDescriptors(arrayList);
        return arrayList;
    }

    Object getPropertyValue(IProperty iProperty) {
        return iProperty.getValue(this.sourceObject);
    }

    AbstractPropertySource<?> getPropertySourceInstanceFor(Class<? extends AbstractPropertySource<?>> clazz) {
        AbstractPropertySource<?> abstractPropertySource = null;
        if (this.getPropertySourceClass() == clazz) {
            abstractPropertySource = this;
        } else {
            Iterator<AbstractPropertySource<?>> iterator = this.childPropSourceList.iterator();
            while (iterator.hasNext() && abstractPropertySource == null) {
                AbstractPropertySource<?> abstractPropertySource2 = iterator.next();
                abstractPropertySource = abstractPropertySource2.getPropertySourceInstanceFor(clazz);
            }
        }
        return abstractPropertySource;
    }

    protected void appendDescriptors(List<IPropertyDescriptor> list) {
        for (IProperty<ESourceType> iProperty : this.getStaticProperties()) {
            if (!iProperty.isShowEmptyValue() && iProperty.getValue(this.sourceObject) == null) continue;
            list.add(iProperty.getDescriptor(this.getPropertySourceClass()));
        }
        if (this.childPropSourceList != null) {
            for (AbstractPropertySource abstractPropertySource : this.childPropSourceList) {
                abstractPropertySource.appendDescriptors(list);
            }
        }
    }

    protected void addChildSource(AbstractPropertySource<?> abstractPropertySource) {
        this.childPropSourceList.add(abstractPropertySource);
    }
}

