/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import eu.geclipse.ui.properties.Messages;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfoSource
extends AbstractPropertySource<IFileInfo> {
    private static List<IProperty<IFileInfo>> staticProperties;
    private static List<Attribute> attributes;

    public FileInfoSource(IFileInfo iFileInfo) {
        super(iFileInfo);
    }

    @Override
    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return FileInfoSource.class;
    }

    @Override
    protected List<IProperty<IFileInfo>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = FileInfoSource.createProperties();
        }
        return staticProperties;
    }

    private static List<IProperty<IFileInfo>> createProperties() {
        ArrayList<IProperty<IFileInfo>> arrayList = new ArrayList<IProperty<IFileInfo>>();
        arrayList.add(FileInfoSource.createName());
        arrayList.add(FileInfoSource.createLength());
        arrayList.add(FileInfoSource.createLastModified());
        arrayList.add(FileInfoSource.createAttributes());
        arrayList.add(FileInfoSource.createLinkTarget());
        return arrayList;
    }

    protected static List<Attribute> getAttributes() {
        if (attributes == null) {
            attributes = Arrays.asList(new Attribute(4, Messages.getString("FileInfoSource.attrExecutable")), new Attribute(32, Messages.getString("FileInfoSource.attrLink")), new Attribute(16, Messages.getString("FileInfoSource.attrHidden")), new Attribute(8, Messages.getString("FileInfoSource.attrArchive")), new Attribute(2, Messages.getString("FileInfoSource.attrReadOnly")));
        }
        return attributes;
    }

    private static IProperty<IFileInfo> createName() {
        return new AbstractProperty<IFileInfo>(Messages.getString("FileInfoSource.propName"), null){

            @Override
            public Object getValue(IFileInfo iFileInfo) {
                return iFileInfo.getName();
            }
        };
    }

    private static IProperty<IFileInfo> createLength() {
        return new AbstractProperty<IFileInfo>(Messages.getString("FileInfoSource.propLength"), null, false){

            @Override
            public Object getValue(IFileInfo iFileInfo) {
                String string = null;
                if (!iFileInfo.isDirectory()) {
                    string = this.getBytesFormattedString(iFileInfo.getLength());
                }
                return string;
            }
        };
    }

    private static IProperty<IFileInfo> createLastModified() {
        return new AbstractProperty<IFileInfo>(Messages.getString("FileInfoSource.propLastModified"), null, false){

            @Override
            public Object getValue(IFileInfo iFileInfo) {
                String string = null;
                if (iFileInfo.getLastModified() != 0L) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(iFileInfo.getLastModified());
                    string = DateFormat.getDateTimeInstance().format(calendar.getTime());
                }
                return string;
            }
        };
    }

    private static IProperty<IFileInfo> createAttributes() {
        return new AbstractProperty<IFileInfo>(Messages.getString("FileInfoSource.propAttributes"), null, false){

            @Override
            public Object getValue(IFileInfo iFileInfo) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Attribute attribute : FileInfoSource.getAttributes()) {
                    if (!iFileInfo.getAttribute(attribute.efsId)) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(attribute.name);
                }
                return stringBuilder.length() > 0 ? stringBuilder : null;
            }
        };
    }

    private static IProperty<IFileInfo> createLinkTarget() {
        return new AbstractProperty<IFileInfo>(Messages.getString("FileInfoSource.propLinkTarget"), null, false){

            @Override
            public Object getValue(IFileInfo iFileInfo) {
                return iFileInfo.getStringAttribute(64);
            }
        };
    }

    protected static class Attribute {
        final int efsId;
        final String name;

        Attribute(int n, String string) {
            this.efsId = n;
            this.name = string;
        }
    }
}

