/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.FileInfoSource;
import eu.geclipse.ui.properties.IProperty;
import eu.geclipse.ui.properties.Messages;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridConnectionElementSource
extends AbstractPropertySource<IGridConnectionElement> {
    private static List<IProperty<IGridConnectionElement>> staticProperties;

    public GridConnectionElementSource(IGridConnectionElement iGridConnectionElement) {
        super(iGridConnectionElement);
        try {
            if (iGridConnectionElement.getConnectionFileInfo() != null) {
                this.addChildSource(new FileInfoSource(iGridConnectionElement.getConnectionFileInfo()));
            }
        }
        catch (CoreException coreException) {
            Activator.logException(coreException);
        }
    }

    @Override
    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return GridConnectionElementSource.class;
    }

    @Override
    protected List<IProperty<IGridConnectionElement>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = GridConnectionElementSource.createProperties();
        }
        return staticProperties;
    }

    private static List<IProperty<IGridConnectionElement>> createProperties() {
        ArrayList<IProperty<IGridConnectionElement>> arrayList = new ArrayList<IProperty<IGridConnectionElement>>();
        arrayList.add(GridConnectionElementSource.createUri());
        return arrayList;
    }

    private static IProperty<IGridConnectionElement> createUri() {
        return new AbstractProperty<IGridConnectionElement>(Messages.getString("GridConnectionElementSource.uri"), null, false){

            @Override
            public Object getValue(IGridConnectionElement iGridConnectionElement) {
                String string = null;
                IGridConnectionElement iGridConnectionElement2 = iGridConnectionElement;
                int n = 0;
                while (iGridConnectionElement2 != null && !(iGridConnectionElement2 instanceof IGridConnection)) {
                    iGridConnectionElement2 = iGridConnectionElement2.getParent();
                    ++n;
                }
                if (iGridConnectionElement2 != null && iGridConnectionElement2 instanceof IGridConnection) {
                    URI uRI = ((IGridConnection)iGridConnectionElement2).getURI();
                    IPath iPath = iGridConnectionElement.getPath();
                    if (n <= iPath.segmentCount()) {
                        IPath iPath2 = iPath.removeFirstSegments(iPath.segmentCount() - n);
                        try {
                            URI uRI2 = uRI.resolve(iPath2.toString());
                            string = uRI2.toString();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
                return string;
            }
        };
    }
}

