/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.PropertyId;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultilineProperty<ESourceType>
extends AbstractProperty<ESourceType> {
    private static ILabelProvider multilineLabelProvider = null;

    public MultilineProperty(String string, String string2) {
        super(string, string2);
        if (multilineLabelProvider == null) {
            multilineLabelProvider = MultilineProperty.createLabelProvider();
        }
        this.setLabelProvider(MultilineProperty.createLabelProvider());
    }

    @Override
    protected PropertyDescriptor createDescriptor(PropertyId<ESourceType> propertyId, String string) {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(propertyId, string){

            public CellEditor createPropertyEditor(Composite composite) {
                return MultilineProperty.this.createCellEditor(composite);
            }
        };
        return propertyDescriptor;
    }

    protected CellEditor createCellEditor(Composite composite) {
        return new DialogCellEditor(composite){

            protected Object openDialogBox(Control control) {
                PropertyDialog propertyDialog = new PropertyDialog(control.getShell());
                Object object = this.getValue();
                if (object != null && object instanceof String) {
                    propertyDialog.setValue((String)object);
                }
                propertyDialog.open();
                return null;
            }
        };
    }

    private static ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public String getText(Object object) {
                String string = object instanceof String ? this.removeNewLineChars((String)object) : object.toString();
                return string;
            }

            private String removeNewLineChars(String string) {
                String string2 = string;
                int n = -1;
                int n2 = 0;
                while (n2 < string.length() && n == -1) {
                    if (string.charAt(n2) == '\r' || string.charAt(n2) == '\n') {
                        n = n2;
                    }
                    ++n2;
                }
                if (n > -1) {
                    string2 = String.valueOf(string.substring(0, n)) + "...";
                }
                return string2;
            }
        };
    }

    private class PropertyDialog
    extends Dialog {
        private Text valueText;
        private String valueString;

        protected PropertyDialog(Shell shell) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            this.valueText = new Text(composite2, 2888);
            if (this.valueString != null) {
                this.valueText.setText(this.valueString);
            }
            GridData gridData = new GridData(1808);
            gridData.heightHint = 200;
            gridData.widthHint = 350;
            this.valueText.setLayoutData((Object)gridData);
            this.getShell().setText(MultilineProperty.this.getName());
            return composite2;
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        }

        void setValue(String string) {
            this.valueString = string;
        }
    }
}

