/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import eu.geclipse.ui.properties.Messages;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIPropertySource
extends AbstractPropertySource<URI> {
    private static List<IProperty<URI>> staticProperties;

    public URIPropertySource(URI uRI) {
        super(URIPropertySource.getRealUri(uRI));
    }

    @Override
    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return URIPropertySource.class;
    }

    @Override
    protected List<IProperty<URI>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = URIPropertySource.createProperties();
        }
        return staticProperties;
    }

    private static List<IProperty<URI>> createProperties() {
        ArrayList<IProperty<URI>> arrayList = new ArrayList<IProperty<URI>>(4);
        arrayList.add(URIPropertySource.createHost());
        arrayList.add(URIPropertySource.createPath());
        arrayList.add(URIPropertySource.createPort());
        arrayList.add(URIPropertySource.createScheme());
        return arrayList;
    }

    private static IProperty<URI> createHost() {
        return new AbstractProperty<URI>(Messages.getString("URIPropertySource.propertyHost"), Messages.getString("URIPropertySource.categoryUri")){

            @Override
            public Object getValue(URI uRI) {
                return uRI.getHost();
            }
        };
    }

    private static IProperty<URI> createPath() {
        return new AbstractProperty<URI>(Messages.getString("URIPropertySource.propertyPath"), Messages.getString("URIPropertySource.categoryUri")){

            @Override
            public Object getValue(URI uRI) {
                return uRI.getPath();
            }
        };
    }

    private static IProperty<URI> createPort() {
        return new AbstractProperty<URI>(Messages.getString("URIPropertySource.propertyPort"), Messages.getString("URIPropertySource.categoryUri")){

            @Override
            public Object getValue(URI uRI) {
                String string = null;
                if (uRI.getPort() != -1) {
                    string = String.valueOf(uRI.getPort());
                }
                return string;
            }
        };
    }

    private static IProperty<URI> createScheme() {
        return new AbstractProperty<URI>(Messages.getString("URIPropertySource.propertyScheme"), Messages.getString("URIPropertySource.categoryUri")){

            @Override
            public Object getValue(URI uRI) {
                String string = null;
                if (uRI.getPort() != -1) {
                    string = String.valueOf(uRI.getScheme());
                }
                return string;
            }
        };
    }

    static URI getRealUri(URI uRI) {
        URI uRI2 = new GEclipseURI(uRI).toSlaveURI();
        return uRI2 != null ? uRI2 : uRI;
    }
}

