/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.providers.GridModelContentProvider;
import eu.geclipse.ui.providers.IConfigurationListener;
import eu.geclipse.ui.providers.ProgressTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class ConfigurableContentProvider
extends GridModelContentProvider {
    public static final int MODE_FLAT = 1;
    public static final int MODE_HIERARCHICAL = 2;
    private int mode = 1;
    private Object rootElement;
    private List<IConfigurationListener> listeners = new ArrayList<IConfigurationListener>();

    public void addConfigurationListener(IConfigurationListener iConfigurationListener) {
        this.listeners.add(iConfigurationListener);
    }

    public Object[] getChildren(Object object) {
        Object[] objectArray = super.getChildren(object);
        if (this.mode == 2) {
            objectArray = this.filterChildren(objectArray);
        }
        return objectArray;
    }

    public Object[] getElements(Object object) {
        this.rootElement = object;
        Object[] objectArray = super.getElements(object);
        if (this.mode == 2) {
            objectArray = this.remapElements(object, objectArray);
        }
        return objectArray;
    }

    public void setMode(int n) {
        if (this.mode != n) {
            this.mode = n;
            this.fireConfigurationChanged();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void removeConfigurationListener(IConfigurationListener iConfigurationListener) {
        this.listeners.remove(iConfigurationListener);
    }

    protected void fireConfigurationChanged() {
        for (IConfigurationListener iConfigurationListener : this.listeners) {
            iConfigurationListener.configurationChanged(this);
        }
    }

    protected boolean isVisible(IGridElement iGridElement) {
        boolean bl = false;
        Object[] objectArray = super.getChildren(this.rootElement);
        IPath iPath = iGridElement.getPath();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath iPath2;
            Object object = objectArray2[n2];
            if (object instanceof IGridElement && (iPath.isPrefixOf(iPath2 = ((IGridElement)object).getPath()) || iPath2.isPrefixOf(iPath))) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    private Object[] filterChildren(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                if (object instanceof IGridElement && this.isVisible((IGridElement)object) || object instanceof ProgressTreeNode) {
                    arrayList.add(object);
                }
                ++n2;
            }
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    private Object[] remapElements(Object object, Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2 = objectArray2[n2];
            if (object2 instanceof IGridElement && object instanceof IGridContainer) {
                object2 = this.remapElement((IGridContainer)object, (IGridElement)object2);
            }
            if (!arrayList.contains(object2)) {
                arrayList.add(object2);
            }
            ++n2;
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    protected Object remapElement(IGridContainer iGridContainer, IGridElement iGridElement) {
        IGridElement iGridElement2 = iGridElement;
        IPath iPath = iGridContainer.getPath();
        IPath iPath2 = iGridElement.getPath();
        int n = iPath2.segmentCount();
        int n2 = iPath2.matchingFirstSegments(iPath);
        if (n2 != n - 1) {
            IPath iPath3 = iPath2.removeLastSegments(n - n2 - 1);
            iGridElement2 = GridModel.getRoot().findElement(iPath3);
        }
        return iGridElement2;
    }
}

