/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.providers.ElementManagerLabelProvider;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.CoreException;

public class ConnectionViewLabelProvider
extends ElementManagerLabelProvider {
    private static final String[] prefixes = new String[]{"", "k", "M", "G", "T", "P", "E", "Z", "Y"};
    private static final String FILE_SIZE_UNIT = "B";
    private static final String FILE_SIZE_FORMAT = "0.###";
    private DateFormat dateFormat = new SimpleDateFormat();
    private DecimalFormat sizeFormat = new DecimalFormat("0.###");

    protected String getColumnText(IGridElement iGridElement, int n) {
        String string = "";
        if (iGridElement instanceof IGridConnectionElement && !(iGridElement instanceof IGridConnection)) {
            IGridConnectionElement iGridConnectionElement = (IGridConnectionElement)iGridElement;
            IFileInfo iFileInfo = null;
            try {
                iFileInfo = iGridConnectionElement.getConnectionFileInfo();
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
            if (iFileInfo != null) {
                switch (n) {
                    case 2: {
                        string = this.getSizeString(iFileInfo);
                        break;
                    }
                    case 3: {
                        string = this.getModificationString(iFileInfo);
                    }
                }
            }
        }
        return string;
    }

    private String getModificationString(IFileInfo iFileInfo) {
        long l;
        String string = "N/A";
        if (iFileInfo != null && (l = iFileInfo.getLastModified()) != 0L) {
            Date date = new Date(l);
            string = this.dateFormat.format(date);
        }
        return string;
    }

    private String getSizeString(IFileInfo iFileInfo) {
        long l;
        String string = "N/A";
        if (iFileInfo != null && (l = iFileInfo.getLength()) != 0L) {
            double d = Math.floor(Math.log(l) / Math.log(1024.0));
            if (d >= (double)prefixes.length) {
                d = prefixes.length - 1;
            }
            double d2 = Math.pow(1024.0, d);
            double d3 = (double)l / d2;
            string = String.valueOf(this.sizeFormat.format(d3)) + " " + prefixes[(int)d] + FILE_SIZE_UNIT;
        }
        return string;
    }
}

