/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.providers.GridModelComparator;
import eu.geclipse.ui.providers.Messages;
import eu.geclipse.ui.providers.ProgressRunner;
import eu.geclipse.ui.providers.ProgressTreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public class GridModelContentProvider
implements ITreeContentProvider,
ITreeViewerListener {
    protected TreeViewer treeViewer;
    private GridModelComparator comparator = new GridModelComparator();

    public Object[] getChildren(Object object) {
        Object[] objectArray = null;
        if (this.hasChildren(object)) {
            objectArray = this.getChildren((IGridContainer)object);
        }
        if (objectArray != null) {
            Arrays.sort(objectArray, this.comparator);
        }
        return objectArray;
    }

    public Object getParent(Object object) {
        IGridContainer iGridContainer = null;
        if (object instanceof IGridElement) {
            iGridContainer = ((IGridElement)object).getParent();
        }
        return iGridContainer;
    }

    public boolean hasChildren(Object object) {
        boolean bl = false;
        if (object instanceof IGridContainer) {
            bl = ((IGridContainer)object).hasChildren();
        }
        return bl;
    }

    public Object[] getElements(Object object) {
        Object[] objectArray = this.getChildren(object);
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        return objectArray;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (viewer instanceof TreeViewer) {
            this.treeViewerChanged(this.treeViewer, (TreeViewer)viewer);
        }
    }

    protected Object[] getChildren(IGridContainer iGridContainer) {
        Object[] objectArray = null;
        if (iGridContainer.isLazy() && iGridContainer.isDirty()) {
            ProgressRunner progressRunner = new ProgressRunner(this.treeViewer, iGridContainer);
            ProgressTreeNode progressTreeNode = progressRunner.getMonitor();
            Thread thread = new Thread(progressRunner);
            thread.start();
            objectArray = new Object[]{progressTreeNode};
        } else {
            try {
                IGridElement[] iGridElementArray = iGridContainer.getChildren(null);
                ArrayList<IGridElement> arrayList = new ArrayList<IGridElement>();
                IGridElement[] iGridElementArray2 = iGridElementArray;
                int n = iGridElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement iGridElement = iGridElementArray2[n2];
                    if (!iGridElement.isHidden()) {
                        arrayList.add(iGridElement);
                    }
                    ++n2;
                }
                objectArray = arrayList.toArray(new IGridElement[arrayList.size()]);
            }
            catch (GridModelException gridModelException) {
                if (this.treeViewer != null) {
                    Shell shell = this.treeViewer.getControl().getShell();
                    NewProblemDialog.openProblem(shell, Messages.getString("GridModelContentProvider.problem_title"), String.valueOf(Messages.getString("GridModelContentProvider.problem_text")) + iGridContainer.getName(), gridModelException);
                }
                Activator.logException(gridModelException);
            }
        }
        return objectArray;
    }

    protected void treeViewerChanged(TreeViewer treeViewer, TreeViewer treeViewer2) {
        if (treeViewer != treeViewer2) {
            this.treeViewer = treeViewer2;
            if (treeViewer != null) {
                treeViewer.removeTreeListener((ITreeViewerListener)this);
            }
            if (treeViewer2 != null) {
                treeViewer2.addTreeListener((ITreeViewerListener)this);
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        Object object = treeExpansionEvent.getElement();
        if (object instanceof IGridContainer) {
            ((IGridContainer)object).setDirty();
            this.treeViewer.setChildCount(object, 0);
            this.treeViewer.setChildCount(object, 1);
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
    }
}

