/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.providers.ProgressTreeNode;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GridModelLabelProvider
extends LabelProvider
implements ILabelProviderListener {
    private Image computingImage;
    private Image fileImage;
    private Image folderImage;
    private Image invalidElementImage;
    private Image serviceImage;
    private Image storageImage;
    private Image virtualFileImage;
    private Image virtualFolderImage;
    private Image voImage;
    private ILabelProvider workbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
    private ILabelDecorator labelDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();

    public GridModelLabelProvider() {
        this.workbenchLabelProvider.addListener((ILabelProviderListener)this);
    }

    public void dispose() {
        this.workbenchLabelProvider.removeListener((ILabelProviderListener)this);
        super.dispose();
    }

    public Image getImage(Object object) {
        Image image = null;
        if (object instanceof IVirtualOrganization) {
            image = this.getVoImage();
        } else if (object instanceof IGridComputing) {
            image = this.getComputingImage();
        } else if (object instanceof IGridStorage) {
            image = this.getStorageImage();
        } else if (object instanceof IGridService) {
            image = this.getServiceImage();
        } else if (object instanceof IGridElement) {
            ImageDescriptor imageDescriptor;
            IGridElement iGridElement = (IGridElement)object;
            IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)iGridElement.getAdapter(IWorkbenchAdapter.class);
            if (iWorkbenchAdapter != null && (imageDescriptor = iWorkbenchAdapter.getImageDescriptor(object)) != null) {
                image = imageDescriptor.createImage();
                PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator().decorateImage(image, object);
            }
            if (image == null) {
                imageDescriptor = ((IGridElement)object).getResource();
                image = imageDescriptor != null && imageDescriptor.getProject() != null ? this.workbenchLabelProvider.getImage((Object)imageDescriptor) : (object instanceof IGridContainer ? this.getFolderImage(((IGridElement)object).isVirtual()) : this.getFileImage(((IGridElement)object).isVirtual()));
            }
        }
        return image;
    }

    public String getText(Object object) {
        IResource iResource;
        String string = null;
        if (object instanceof IGridElement) {
            string = ((IGridElement)object).getName();
            iResource = ((IGridElement)object).getResource();
            if (iResource != null && iResource.getProject() != null) {
                string = this.labelDecorator.decorateText(string, object);
            }
        } else if (object instanceof ProgressTreeNode) {
            string = object.toString();
        }
        if (object instanceof IGridConnectionElement && !(iResource = (IGridConnectionElement)object).isValid()) {
            string = String.valueOf(string) + "(Error: " + iResource.getError() + ")";
        }
        return string;
    }

    protected Image getFolderImage(boolean bl) {
        Image image;
        if (bl) {
            if (this.virtualFolderImage == null) {
                this.virtualFolderImage = Activator.getDefault().getImageRegistry().get("virtualfolder");
            }
            image = this.virtualFolderImage;
        } else {
            if (this.folderImage == null) {
                this.folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            image = this.folderImage;
        }
        return image;
    }

    protected Image getFileImage(boolean bl) {
        Image image = null;
        if (bl) {
            if (this.virtualFileImage == null) {
                this.virtualFileImage = Activator.getDefault().getImageRegistry().get("virtualfile");
            }
            image = this.virtualFileImage;
        } else {
            if (this.fileImage == null) {
                this.fileImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            image = this.fileImage;
        }
        return image;
    }

    protected Image getVoImage() {
        if (this.voImage == null) {
            this.voImage = Activator.getDefault().getImageRegistry().get("vo");
        }
        return this.voImage;
    }

    protected Image getInvalidElementImage() {
        if (this.invalidElementImage == null) {
            this.invalidElementImage = Activator.getDefault().getImageRegistry().get("invalidelement");
        }
        return this.invalidElementImage;
    }

    private Image getServiceImage() {
        if (this.serviceImage == null) {
            this.serviceImage = Activator.getDefault().getImageRegistry().get("service");
        }
        return this.serviceImage;
    }

    private Image getStorageImage() {
        if (this.storageImage == null) {
            this.storageImage = Activator.getDefault().getImageRegistry().get("storage");
        }
        return this.storageImage;
    }

    private Image getComputingImage() {
        if (this.computingImage == null) {
            this.computingImage = Activator.getDefault().getImageRegistry().get("computing");
        }
        return this.computingImage;
    }

    public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }
}

