/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ProgressTreeNode
implements IProgressMonitor,
Listener {
    private static final int DEFAULT_PROGRESS_BAR_WIDTH = 50;
    private static final int DEFAULT_PROGRESS_BAR_MARGIN = 5;
    private static final int DEFAULT_TEXT_GAP = 5;
    protected double worked;
    protected String taskName;
    private int tWork;
    private String errorString;
    private boolean canceled;
    private boolean done;
    private TreeViewer treeViewer;
    private ProgressNodeUpdater updater;

    protected ProgressTreeNode(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.updater = new ProgressNodeUpdater(this);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTask(String string, int n) {
        ProgressTreeNode progressTreeNode = this;
        synchronized (progressTreeNode) {
            this.taskName = string;
            this.tWork = n;
            this.worked = 0.0;
            this.canceled = false;
            this.done = false;
        }
        this.update();
    }

    public void done() {
        this.worked = this.tWork;
        this.done = true;
        this.update();
    }

    public void internalWorked(double d) {
        this.worked += d;
        this.update();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
        this.update();
    }

    public void setError(String string) {
        this.errorString = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskName(String string) {
        String string2 = this.taskName;
        synchronized (string2) {
            this.taskName = string;
        }
        this.update();
    }

    public void subTask(String string) {
        this.setTaskName(string);
    }

    public void worked(int n) {
        this.internalWorked(n);
    }

    public void handleEvent(Event event) {
        Object object;
        if (event.item instanceof TreeItem && event.index == 0 && (object = ((TreeItem)event.item).getData()) == this) {
            switch (event.type) {
                case 41: {
                    this.measureItem(event);
                    break;
                }
                case 40: {
                    this.eraseItem(event);
                    break;
                }
                case 42: {
                    this.paintItem(event);
                }
            }
        }
    }

    public String toString() {
        String string = String.valueOf(this.taskName) + " (" + String.valueOf(this.getProgressPercent()) + ")";
        return string;
    }

    protected long getProgressPercent() {
        return Math.round(100.0 * this.worked / (double)this.tWork);
    }

    protected void measureItem(Event event) {
        event.height = event.gc.getFontMetrics().getHeight();
        event.width = this.getProgressBarWidth(event.gc) + 3;
        if (this.taskName != null) {
            event.width += 5 + event.gc.textExtent((String)this.taskName).x;
        }
    }

    protected void eraseItem(Event event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintItem(Event event) {
        String string;
        ProgressTreeNode progressTreeNode = this;
        synchronized (progressTreeNode) {
            string = this.taskName;
        }
        progressTreeNode = this.treeViewer.getTree().getDisplay();
        Color color = progressTreeNode.getSystemColor(2);
        Color color2 = progressTreeNode.getSystemColor(1);
        Color color3 = progressTreeNode.getSystemColor(3);
        Color color4 = progressTreeNode.getSystemColor(7);
        Color color5 = progressTreeNode.getSystemColor(9);
        Color color6 = event.gc.getBackground();
        long l = this.getProgressPercent();
        int n = this.getProgressBarWidth(event.gc);
        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        event.gc.setForeground(color);
        event.gc.setBackground(this.isDone() ? color5 : color6);
        event.gc.drawRectangle(event.x + 1, event.y + 1, n + 1, event.height - 3);
        if (this.isDone()) {
            event.gc.fillRectangle(event.x + 1, event.y + 1, n + 1, event.height - 3);
        }
        event.gc.drawRectangle(event.x + 1, event.y + 1, n + 1, event.height - 3);
        if (!this.isDone()) {
            event.gc.setClipping(event.x + 2, event.y + 2, (int)((double)((long)n * l) / 100.0), event.height - 4);
            event.gc.setForeground(color3);
            event.gc.setBackground(color4);
            event.gc.fillGradientRectangle(event.x + 2, event.y + 2, n, event.height - 4, false);
            event.gc.setClipping(null);
        }
        String string2 = this.isDone() ? "done" : String.valueOf(String.valueOf(l)) + "%";
        Point point = event.gc.textExtent(string2);
        int n2 = event.x + 2 + (n - point.x) / 2;
        event.gc.setForeground(color2);
        event.gc.drawText(string2, n2 + 1, event.y + 2, true);
        event.gc.setForeground(color);
        event.gc.drawText(string2, n2, event.y + 1, true);
        int n3 = event.x + 2 + n + 5;
        if (this.errorString != null) {
            event.gc.setForeground(color3);
            event.gc.drawText(this.errorString, n3, event.y + 1, true);
        } else if (string != null) {
            event.gc.setForeground(color);
            event.gc.drawText(string, n3, event.y + 1, true);
        }
    }

    private int getProgressBarWidth(GC gC) {
        Point point = gC.textExtent("100%");
        int n = 50;
        int n2 = point.x + 10;
        if (n < n2) {
            n = n2;
        }
        return n;
    }

    private void update() {
        Tree tree = this.treeViewer.getTree();
        if (!tree.isDisposed()) {
            Display display = tree.getDisplay();
            display.asyncExec((Runnable)this.updater);
        }
    }

    private class ProgressNodeUpdater
    implements Runnable {
        private ProgressTreeNode node;
        private String lastProgress;

        public ProgressNodeUpdater(ProgressTreeNode progressTreeNode2) {
            this.node = progressTreeNode2;
        }

        public void run() {
            String string = this.node.toString();
            if (string != null && !string.equals(this.lastProgress)) {
                this.lastProgress = string;
                this.node.getTreeViewer().update((Object)ProgressTreeNode.this, null);
            }
        }

        public void reset() {
            this.lastProgress = null;
        }
    }
}

