/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.AuthenticationTokenManager;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.ui.AbstractAuthTokenUIFactory;
import eu.geclipse.ui.IAuthTokenUIFactory;
import eu.geclipse.ui.UIAuthTokenProvider;
import eu.geclipse.ui.cheatsheets.OpenAuthTokenDialogAction;
import eu.geclipse.ui.dialogs.AuthTokenInfoDialog;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.views.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthTokenView
extends ViewPart
implements IContentChangeListener {
    protected Table tokenTable;
    protected CheckboxTableViewer tokenList;
    protected IContributionItem newWizardMenu;
    private Action newAction;
    private Action deleteAction;
    private Action activateAction;
    private Action deactivateAction;
    private Action infoAction;
    private Action refreshAction;
    private IMenuCreator newActionMenuCreator = new IMenuCreator(){
        private MenuManager dropDownMenuMgr;

        private void createDropDownMenuMgr() {
            if (this.dropDownMenuMgr == null) {
                this.dropDownMenuMgr = new MenuManager();
                this.dropDownMenuMgr.add(AuthTokenView.this.newWizardMenu);
            }
        }

        public void dispose() {
            if (this.dropDownMenuMgr != null) {
                this.dropDownMenuMgr.dispose();
                this.dropDownMenuMgr = null;
            }
        }

        public Menu getMenu(Control control) {
            this.createDropDownMenuMgr();
            return this.dropDownMenuMgr.createContextMenu(control);
        }

        public Menu getMenu(Menu menu) {
            this.createDropDownMenuMgr();
            Menu menu2 = new Menu(menu);
            IContributionItem[] iContributionItemArray = this.dropDownMenuMgr.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                IContributionItem iContributionItem;
                IContributionItem iContributionItem2 = iContributionItem = iContributionItemArray[n];
                if (iContributionItem instanceof ActionContributionItem) {
                    iContributionItem2 = new ActionContributionItem(((ActionContributionItem)iContributionItem).getAction());
                }
                iContributionItem2.fill(menu2, -1);
                ++n;
            }
            return menu2;
        }
    };

    public void createPartControl(Composite composite) {
        this.tokenTable = new Table(composite, 65570);
        this.tokenTable.setHeaderVisible(true);
        this.tokenTable.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.tokenTable, 16384);
        tableColumn.setText(Messages.getString("AuthTokenView.id_column_label"));
        tableColumn.setWidth(300);
        tableColumn.setAlignment(16384);
        TableColumn tableColumn2 = new TableColumn(this.tokenTable, 0x1000000);
        tableColumn2.setText(Messages.getString("AuthTokenView.type_column_label"));
        tableColumn2.setWidth(150);
        tableColumn2.setAlignment(0x1000000);
        TableColumn tableColumn3 = new TableColumn(this.tokenTable, 0x1000000);
        tableColumn3.setText(Messages.getString("AuthTokenView.state_column_label"));
        tableColumn3.setWidth(100);
        tableColumn3.setAlignment(0x1000000);
        TableColumn tableColumn4 = new TableColumn(this.tokenTable, 0x1000000);
        tableColumn4.setText(Messages.getString("AuthTokenView.lifetime_column_label"));
        tableColumn4.setWidth(150);
        tableColumn4.setAlignment(0x1000000);
        AuthenticationTokenManager authenticationTokenManager = AuthenticationTokenManager.getManager();
        this.tokenList = new CheckboxTableViewer(this.tokenTable);
        this.tokenList.setLabelProvider((IBaseLabelProvider)new AuthenticationTokenLabelProvider());
        this.tokenList.setContentProvider((IContentProvider)new AuthenticationTokenContentProvider());
        this.tokenList.setInput((Object)authenticationTokenManager);
        IAuthenticationToken iAuthenticationToken = authenticationTokenManager.getDefaultToken();
        if (iAuthenticationToken != null) {
            this.tokenList.setCheckedElements(new Object[]{iAuthenticationToken});
        }
        this.tokenList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                AuthTokenView.this.updateActions();
            }
        });
        this.tokenList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Object object = checkStateChangedEvent.getElement();
                if (object instanceof IAuthenticationToken) {
                    IAuthenticationToken iAuthenticationToken = (IAuthenticationToken)object;
                    AuthenticationTokenManager authenticationTokenManager = AuthenticationTokenManager.getManager();
                    if (!checkStateChangedEvent.getChecked()) {
                        authenticationTokenManager.setDefaultToken(null);
                    }
                    authenticationTokenManager.setDefaultToken(iAuthenticationToken);
                }
            }
        });
        this.tokenList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                AuthTokenView.this.showSelectedTokenInfo();
            }
        });
        this.tokenTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
                    AuthTokenView.this.removeSelectedTokens();
                }
            }
        });
        authenticationTokenManager.addContentChangeListener((IContentChangeListener)this);
        this.createActions();
        this.createToolbar();
        this.createContextMenu();
    }

    public void dispose() {
        AuthenticationTokenManager authenticationTokenManager = AuthenticationTokenManager.getManager();
        authenticationTokenManager.removeContentChangeListener((IContentChangeListener)this);
    }

    public void contentChanged(IContentChangeNotifier iContentChangeNotifier) {
        this.tokenList.refresh();
        AuthenticationTokenManager authenticationTokenManager = AuthenticationTokenManager.getManager();
        IAuthenticationToken iAuthenticationToken = authenticationTokenManager.getDefaultToken();
        if (iAuthenticationToken != null) {
            this.tokenList.setCheckedElements(new Object[]{iAuthenticationToken});
        }
        this.updateActions();
    }

    public void setFocus() {
        this.tokenTable.setFocus();
    }

    public IAuthenticationToken getSelectedToken() {
        IAuthenticationToken iAuthenticationToken = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tokenList.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IAuthenticationToken) {
            iAuthenticationToken = (IAuthenticationToken)object;
        }
        return iAuthenticationToken;
    }

    public List<IAuthenticationToken> getSelectedTokens() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tokenList.getSelection();
        List list = iStructuredSelection.toList();
        ArrayList<IAuthenticationToken> arrayList = new ArrayList<IAuthenticationToken>();
        for (Object e : list) {
            if (!(e instanceof IAuthenticationToken)) continue;
            IAuthenticationToken iAuthenticationToken = (IAuthenticationToken)e;
            arrayList.add(iAuthenticationToken);
        }
        return arrayList;
    }

    protected void setSelectedTokenActive(final boolean bl) {
        final IAuthenticationToken iAuthenticationToken = this.getSelectedToken();
        if (bl == iAuthenticationToken.isActive()) {
            return;
        }
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getSite().getShell());
        Throwable throwable = null;
        try {
            progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        iAuthenticationToken.setActive(bl, iProgressMonitor);
                    }
                    catch (AuthenticationException authenticationException) {
                        throw new InvocationTargetException(authenticationException);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
        }
        catch (InterruptedException interruptedException) {
            throwable = interruptedException;
        }
        if (throwable != null) {
            String string = bl ? Messages.getString("AuthTokenView.token_activation_error") : Messages.getString("AuthTokenView.token_deactivation_error");
            NewProblemDialog.openProblem(this.getSite().getShell(), Messages.getString("AuthTokenView.token_activation_error_title"), string, throwable);
        }
    }

    protected void removeSelectedTokens() {
        List<IAuthenticationToken> list = this.getSelectedTokens();
        if (!list.isEmpty()) {
            boolean bl;
            boolean bl2 = bl = !MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.getString("AuthTokenView.confirm_delete_title"), (String)Messages.getString("AuthTokenView.confirm_delete_message"));
            if (!bl) {
                AuthenticationTokenManager authenticationTokenManager = AuthenticationTokenManager.getManager();
                for (IAuthenticationToken iAuthenticationToken : list) {
                    try {
                        authenticationTokenManager.destroyToken(iAuthenticationToken);
                    }
                    catch (AuthenticationException authenticationException) {
                        Activator.logException(authenticationException);
                    }
                }
                this.updateActions();
            }
        }
    }

    protected void showSelectedTokenInfo() {
        IAuthTokenUIFactory iAuthTokenUIFactory;
        IAuthenticationToken iAuthenticationToken = this.getSelectedToken();
        if (iAuthenticationToken != null && (iAuthTokenUIFactory = AbstractAuthTokenUIFactory.findFactory(iAuthenticationToken)) != null) {
            AuthTokenInfoDialog authTokenInfoDialog = iAuthTokenUIFactory.getInfoDialog(iAuthenticationToken, this.getSite().getShell());
            authTokenInfoDialog.open();
        }
    }

    protected void updateActions() {
        IAuthenticationToken iAuthenticationToken = this.getSelectedToken();
        boolean bl = iAuthenticationToken != null;
        this.newAction.setEnabled(true);
        this.deleteAction.setEnabled(bl);
        this.activateAction.setEnabled(bl && !iAuthenticationToken.isActive());
        this.deactivateAction.setEnabled(bl && iAuthenticationToken.isActive());
        this.infoAction.setEnabled(bl);
        this.refreshAction.setEnabled(true);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        if (this.newAction.isEnabled()) {
            iMenuManager.add((IAction)this.newAction);
        }
        if (this.deleteAction.isEnabled() || this.activateAction.isEnabled() || this.deactivateAction.isEnabled() || this.infoAction.isEnabled() || this.refreshAction.isEnabled()) {
            iMenuManager.add((IContributionItem)new Separator());
            if (this.deleteAction.isEnabled()) {
                iMenuManager.add((IAction)this.deleteAction);
            }
            if (this.activateAction.isEnabled()) {
                iMenuManager.add((IAction)this.activateAction);
            }
            if (this.deactivateAction.isEnabled()) {
                iMenuManager.add((IAction)this.deactivateAction);
            }
            if (this.infoAction.isEnabled()) {
                iMenuManager.add((IAction)this.infoAction);
            }
            if (this.deleteAction.isEnabled() || this.activateAction.isEnabled() || this.deactivateAction.isEnabled() || this.infoAction.isEnabled()) {
                iMenuManager.add((IContributionItem)new Separator());
            }
            if (this.refreshAction.isEnabled()) {
                iMenuManager.add((IAction)this.refreshAction);
            }
        }
        iMenuManager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void createActions() {
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = iSharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD");
        ImageDescriptor imageDescriptor2 = iSharedImages.getImageDescriptor("IMG_TOOL_DELETE");
        Image image = imageRegistry.get("activestate");
        ImageDescriptor imageDescriptor3 = ImageDescriptor.createFromImage((Image)image);
        image = imageRegistry.get("inactivestate");
        ImageDescriptor imageDescriptor4 = ImageDescriptor.createFromImage((Image)image);
        ImageDescriptor imageDescriptor5 = iSharedImages.getImageDescriptor("IMG_OBJS_INFO_TSK");
        image = imageRegistry.get("refresh");
        ImageDescriptor imageDescriptor6 = ImageDescriptor.createFromImage((Image)image);
        this.infoAction = new Action(){

            public void run() {
                AuthTokenView.this.showSelectedTokenInfo();
            }
        };
        this.infoAction.setText(Messages.getString("AuthTokenView.info_text"));
        this.infoAction.setToolTipText(Messages.getString("AuthTokenView.info_tooltip"));
        this.infoAction.setImageDescriptor(imageDescriptor5);
        this.refreshAction = new Action(){

            public void run() {
                AuthenticationTokenManager authenticationTokenManager = AuthenticationTokenManager.getManager();
                AuthTokenView.this.tokenList.refresh();
                IAuthenticationToken iAuthenticationToken = authenticationTokenManager.getDefaultToken();
                if (iAuthenticationToken != null) {
                    AuthTokenView.this.tokenList.setCheckedElements(new Object[]{iAuthenticationToken});
                }
            }
        };
        this.refreshAction.setText(Messages.getString("AuthTokenView.refresh_text"));
        this.refreshAction.setToolTipText(Messages.getString("AuthTokenView.refresh_tooltip"));
        this.refreshAction.setImageDescriptor(imageDescriptor6);
        this.deleteAction = new Action(){

            public void run() {
                AuthTokenView.this.removeSelectedTokens();
            }
        };
        this.deleteAction.setText(Messages.getString("AuthTokenView.delete_text"));
        this.deleteAction.setToolTipText(Messages.getString("AuthTokenView.delete_tooltip"));
        this.deleteAction.setImageDescriptor(imageDescriptor2);
        this.activateAction = new Action(){

            public void run() {
                AuthTokenView.this.setSelectedTokenActive(true);
            }
        };
        this.activateAction.setText(Messages.getString("AuthTokenView.activate_text"));
        this.activateAction.setToolTipText(Messages.getString("AuthTokenView.activate_tooltip"));
        this.activateAction.setImageDescriptor(imageDescriptor3);
        this.deactivateAction = new Action(){

            public void run() {
                AuthTokenView.this.setSelectedTokenActive(false);
            }
        };
        this.deactivateAction.setText(Messages.getString("AuthTokenView.deactivate_text"));
        this.deactivateAction.setToolTipText(Messages.getString("AuthTokenView.deactivate_tooltip"));
        this.deactivateAction.setImageDescriptor(imageDescriptor4);
        this.newAction = new OpenAuthTokenDialogAction();
        this.newAction.setText(Messages.getString("AuthTokenView.create_text"));
        this.newAction.setToolTipText(Messages.getString("AuthTokenView.create_tooltip"));
        this.newAction.setImageDescriptor(imageDescriptor);
        this.newAction.setMenuCreator(this.newActionMenuCreator);
        this.newWizardMenu = new CompoundContributionItem(){

            protected IContributionItem[] getContributionItems() {
                LinkedList<ActionContributionItem> linkedList = new LinkedList<ActionContributionItem>();
                ExtensionManager extensionManager = new ExtensionManager();
                List list = extensionManager.getConfigurationElements("eu.geclipse.core.authTokens", "token");
                for (IConfigurationElement iConfigurationElement : list) {
                    String string = iConfigurationElement.getAttribute("name");
                    final String string2 = iConfigurationElement.getAttribute("wizard");
                    if (string == null || string2 == null) continue;
                    Action action = new Action(){

                        public void run() {
                            UIAuthTokenProvider uIAuthTokenProvider = new UIAuthTokenProvider(AuthTokenView.this.getSite().getShell());
                            uIAuthTokenProvider.showNewTokenWizard(string2);
                        }
                    };
                    action.setText(string);
                    linkedList.add(new ActionContributionItem((IAction)action));
                }
                return linkedList.toArray(new IContributionItem[0]);
            }
        };
        this.updateActions();
    }

    private void createToolbar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)this.newAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.deleteAction);
        iToolBarManager.add((IAction)this.activateAction);
        iToolBarManager.add((IAction)this.deactivateAction);
        iToolBarManager.add((IAction)this.infoAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.refreshAction);
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                AuthTokenView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.tokenTable);
        this.tokenTable.setMenu(menu);
        this.getSite().registerContextMenu(menuManager, this.getSite().getSelectionProvider());
    }

    class AuthenticationTokenContentProvider
    implements IStructuredContentProvider {
        AuthenticationTokenContentProvider() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = null;
            if (object instanceof AuthenticationTokenManager) {
                List list = ((AuthenticationTokenManager)object).getTokens();
                IAuthenticationToken[] iAuthenticationTokenArray = new IAuthenticationToken[list.size()];
                objectArray = list.toArray(iAuthenticationTokenArray);
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    class AuthenticationTokenLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        private Font boldFont;

        public AuthenticationTokenLabelProvider() {
            Font font = JFaceResources.getDefaultFont();
            Device device = font.getDevice();
            FontData[] fontDataArray = font.getFontData();
            int n = 0;
            while (n < fontDataArray.length) {
                int n2 = fontDataArray[n].getStyle();
                fontDataArray[n].setStyle(n2 | 1);
                ++n;
            }
            this.boldFont = new Font(device, fontDataArray);
        }

        public void dispose() {
            super.dispose();
            this.boldFont.dispose();
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            String string = object.toString();
            if (object instanceof IAuthenticationToken) {
                IAuthenticationToken iAuthenticationToken = (IAuthenticationToken)object;
                switch (n) {
                    case 0: {
                        string = iAuthenticationToken.getID();
                        break;
                    }
                    case 1: {
                        string = iAuthenticationToken.getDescription().getTokenTypeName();
                        break;
                    }
                    case 2: {
                        string = iAuthenticationToken.isActive() ? Messages.getString("AuthTokenView.token_active") : Messages.getString("AuthTokenView.token_inactive");
                        break;
                    }
                    case 3: {
                        if (!iAuthenticationToken.isActive()) {
                            string = "";
                            break;
                        }
                        long l = iAuthenticationToken.getTimeLeft();
                        if (l < 0L) {
                            string = Messages.getString("AuthTokenView.lifetime_infinite");
                            break;
                        }
                        if (l == 0L) {
                            string = Messages.getString("AuthTokenView.lifetime_expired");
                            break;
                        }
                        int n2 = (int)(l / 86400L);
                        int n3 = (int)(l % 86400L / 3600L);
                        int n4 = (int)(l % 3600L / 60L);
                        int n5 = (int)(l % 60L);
                        string = String.format("%1$3dd %2$2dh %3$2dm %4$2ds", new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5));
                    }
                }
            }
            return string;
        }

        public Font getFont(Object object, int n) {
            IAuthenticationToken iAuthenticationToken;
            Font font = null;
            if (object instanceof IAuthenticationToken && (iAuthenticationToken = (IAuthenticationToken)object).isActive()) {
                font = this.boldFont;
            }
            return font;
        }
    }
}

