/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views;

import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.ui.internal.actions.ActionGroupManager;
import eu.geclipse.ui.internal.actions.ViewModeActions;
import eu.geclipse.ui.providers.ConfigurableContentProvider;
import eu.geclipse.ui.providers.GridModelLabelProvider;
import eu.geclipse.ui.providers.IConfigurationListener;
import eu.geclipse.ui.views.Messages;
import eu.geclipse.ui.views.TreeControlViewPart;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public abstract class ElementManagerViewPart
extends TreeControlViewPart
implements IGridModelListener {
    TreeColumn projectColumn;

    protected ElementManagerViewPart() {
        IGridElementManager iGridElementManager = this.getManager();
        iGridElementManager.addGridModelListener((IGridModelListener)this);
    }

    public void gridModelChanged(IGridModelEvent iGridModelEvent) {
        this.refreshViewer(iGridModelEvent.getSource());
    }

    public void dispose() {
        IGridElementManager iGridElementManager = this.getManager();
        iGridElementManager.removeGridModelListener((IGridModelListener)this);
        super.dispose();
    }

    protected void contributeAdditionalActions(ActionGroupManager actionGroupManager) {
        ViewModeActions viewModeActions = new ViewModeActions(this);
        actionGroupManager.addGroup(viewModeActions);
    }

    protected abstract IGridElementManager getManager();

    protected IGridElement getRootElement() {
        return this.getManager();
    }

    protected ConfigurableContentProvider createConfigurableContentProvider() {
        ConfigurableContentProvider configurableContentProvider = new ConfigurableContentProvider();
        return configurableContentProvider;
    }

    protected IContentProvider createContentProvider() {
        ConfigurableContentProvider configurableContentProvider = this.createConfigurableContentProvider();
        configurableContentProvider.addConfigurationListener(new IConfigurationListener(){
            private int lastWidth = 100;

            public void configurationChanged(ConfigurableContentProvider configurableContentProvider) {
                if (ElementManagerViewPart.this.projectColumn != null) {
                    int n = configurableContentProvider.getMode();
                    if (n == 1) {
                        ElementManagerViewPart.this.projectColumn.setWidth(this.lastWidth);
                    } else {
                        this.lastWidth = ElementManagerViewPart.this.projectColumn.getWidth();
                        ElementManagerViewPart.this.projectColumn.setWidth(0);
                    }
                }
            }
        });
        return configurableContentProvider;
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new GridModelLabelProvider();
    }

    protected boolean createTreeColumns(Tree tree) {
        super.createTreeColumns(tree);
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setText(Messages.getString("ElementManagerViewPart.name_column"));
        treeColumn.setAlignment(16384);
        treeColumn.setWidth(300);
        this.projectColumn = new TreeColumn(tree, 0);
        this.projectColumn.setText(Messages.getString("ElementManagerViewPart.project_column"));
        this.projectColumn.setAlignment(16384);
        this.projectColumn.setWidth(100);
        return true;
    }

    public boolean isDragSource(IGridElement iGridElement) {
        return super.isDragSource(iGridElement) && this.getManager().canManage(iGridElement);
    }
}

