/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views;

import eu.geclipse.core.Preferences;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobStatusListener;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.ActionGroupManager;
import eu.geclipse.ui.internal.actions.FilterActions;
import eu.geclipse.ui.internal.actions.JobViewActions;
import eu.geclipse.ui.providers.JobViewLabelProvider;
import eu.geclipse.ui.views.ElementManagerViewPart;
import eu.geclipse.ui.views.Messages;
import eu.geclipse.ui.views.filters.GridFilterConfigurationsManager;
import eu.geclipse.ui.views.filters.IFilterConfigurationListener;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import eu.geclipse.ui.views.filters.JobViewFilterConfiguration;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GridJobView
extends ElementManagerViewPart
implements IGridJobStatusListener,
IFilterConfigurationListener {
    private static String XML_MEMENTO_FILTERS = "Filters";
    private static String PREFERENCE_NAME_FILTERS = "GridJobViewFilters";
    private JobViewActions jobActions;
    private GridFilterConfigurationsManager filterConfigurationsManager;

    public void dispose() {
        GridModel.getJobManager().removeJobStatusListener((IGridJobStatusListener)this);
        if (this.filterConfigurationsManager != null) {
            this.filterConfigurationsManager.removeConfigurationListener(this);
        }
        this.saveFilters();
        super.dispose();
    }

    public void statusChanged(IGridJob iGridJob) {
        this.refreshViewer((IGridElement)iGridJob);
    }

    protected IGridElementManager getManager() {
        return GridModel.getJobManager();
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new JobViewLabelProvider();
    }

    protected boolean createTreeColumns(Tree tree) {
        super.createTreeColumns(tree);
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setText(Messages.getString("GridJobView.id_column"));
        treeColumn.setAlignment(16384);
        treeColumn.setWidth(200);
        TreeColumn treeColumn2 = new TreeColumn(tree, 0);
        treeColumn2.setText(Messages.getString("GridJobView.status_column"));
        treeColumn2.setAlignment(16384);
        treeColumn2.setWidth(100);
        TreeColumn treeColumn3 = new TreeColumn(tree, 0);
        treeColumn3.setText(Messages.getString("GridJobView.reason_column"));
        treeColumn3.setAlignment(16384);
        treeColumn3.setWidth(100);
        TreeColumn treeColumn4 = new TreeColumn(tree, 0);
        treeColumn4.setText(Messages.getString("GridJobView.last_update_column"));
        treeColumn4.setAlignment(16384);
        treeColumn4.setWidth(120);
        return true;
    }

    protected void contributeAdditionalActions(ActionGroupManager actionGroupManager) {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        this.jobActions = new JobViewActions((IWorkbenchSite)iWorkbenchPartSite);
        actionGroupManager.addGroup(this.jobActions);
        actionGroupManager.addGroup(new FilterActions((IWorkbenchSite)this.getSite(), this.filterConfigurationsManager));
        super.contributeAdditionalActions(actionGroupManager);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        GridModel.getJobManager().addJobStatusListener((IGridJobStatusListener)this);
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "eu.geclipse.core");
        scopedPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (GridJobView.this.jobActions != null) {
                    GridJobView.this.jobActions.setJobsUpdateStatus(Preferences.getUpdateJobsStatus());
                }
            }
        });
    }

    protected void initViewer(StructuredViewer structuredViewer) {
        super.initViewer(structuredViewer);
        this.initFilters(structuredViewer);
    }

    private void initFilters(StructuredViewer structuredViewer) {
        this.createFilterConfigurationsManager(structuredViewer);
        this.readFilters();
    }

    private void createFilterConfigurationsManager(StructuredViewer structuredViewer) {
        this.filterConfigurationsManager = new GridFilterConfigurationsManager("JobView"){

            public IGridFilterConfiguration createConfiguration(String string) {
                return new JobViewFilterConfiguration(string);
            }
        };
        this.filterConfigurationsManager.addConfigurationListener(this);
    }

    public void configurationChanged() {
    }

    public void filterConfigurationSelected(ViewerFilter[] viewerFilterArray) {
        if (this.getViewer() != null) {
            this.getViewer().setFilters(viewerFilterArray);
        }
    }

    private void saveFilters() {
        XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)XML_MEMENTO_FILTERS);
        if (this.filterConfigurationsManager != null) {
            this.filterConfigurationsManager.saveState((IMemento)xMLMemento);
        }
        StringWriter stringWriter = new StringWriter();
        try {
            xMLMemento.save((Writer)stringWriter);
        }
        catch (IOException iOException) {
            Activator.logException(iOException);
        }
        org.eclipse.core.runtime.Preferences preferences = Activator.getDefault().getPluginPreferences();
        preferences.setValue(PREFERENCE_NAME_FILTERS, stringWriter.toString());
        Activator.getDefault().savePluginPreferences();
    }

    private void readFilters() {
        String string = Activator.getDefault().getPluginPreferences().getString(PREFERENCE_NAME_FILTERS);
        if (string != null && string.length() > 0) {
            StringReader stringReader = new StringReader(string);
            try {
                this.filterConfigurationsManager.readState((IMemento)XMLMemento.createReadRoot((Reader)stringReader));
            }
            catch (WorkbenchException workbenchException) {
                Activator.logException(workbenchException);
            }
        }
    }
}

