/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.ui.internal.actions.ActionGroupManager;
import eu.geclipse.ui.internal.actions.CommonActions;
import eu.geclipse.ui.internal.actions.FileActions;
import eu.geclipse.ui.internal.actions.OpenActions;
import eu.geclipse.ui.internal.actions.TreeViewerActions;
import eu.geclipse.ui.internal.transfer.SelectionTransferDragAdapter;
import eu.geclipse.ui.internal.transfer.SelectionTransferDropAdapter;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.ViewPart;

public abstract class GridModelViewPart
extends ViewPart
implements IGridModelListener {
    StructuredViewer viewer;
    private ActionGroup actions;
    private OpenActions openActions;

    public void createPartControl(Composite composite) {
        this.viewer = this.createViewer(composite);
        this.initViewer(this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.actions = this.createActions();
        this.fillActionBars(this.actions);
        this.createContextMenu(this.viewer);
        GridModel.getRoot().addGridModelListener((IGridModelListener)this);
    }

    public void dispose() {
        if (this.actions != null) {
            this.actions.dispose();
        }
        GridModel.getRoot().removeGridModelListener((IGridModelListener)this);
        super.dispose();
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void gridModelChanged(IGridModelEvent iGridModelEvent) {
        IGridElement iGridElement = iGridModelEvent.getSource();
        this.refreshViewer(iGridElement);
    }

    public boolean isDragSource(IGridElement iGridElement) {
        return !iGridElement.isVirtual();
    }

    public void refreshViewer() {
        this.refreshViewer(null);
    }

    public void refreshViewer(final IGridElement iGridElement) {
        Display display = this.viewer.getControl().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (iGridElement == null) {
                    GridModelViewPart.this.viewer.refresh();
                } else {
                    GridModelViewPart.this.viewer.refresh((Object)iGridElement);
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected void addDragSourceListeners(DelegatingDragAdapter delegatingDragAdapter) {
        delegatingDragAdapter.addDragSourceListener((TransferDragSourceListener)new SelectionTransferDragAdapter(this));
    }

    protected void addDropTargetListeners(DelegatingDropAdapter delegatingDropAdapter) {
        delegatingDropAdapter.addDropTargetListener((TransferDropTargetListener)new SelectionTransferDropAdapter());
    }

    protected ActionGroup createActions() {
        ActionGroupManager actionGroupManager = new ActionGroupManager();
        this.contributeAdditionalActions(actionGroupManager);
        this.contributeStandardActions(actionGroupManager);
        return actionGroupManager;
    }

    protected void contributeStandardActions(ActionGroupManager actionGroupManager) {
        this.openActions = new OpenActions(this);
        actionGroupManager.addGroup(this.openActions);
        FileActions fileActions = new FileActions(this);
        actionGroupManager.addGroup(fileActions);
        CommonActions commonActions = new CommonActions(this);
        actionGroupManager.addGroup(commonActions);
        StructuredViewer structuredViewer = this.getViewer();
        if (structuredViewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)structuredViewer;
            TreeViewerActions treeViewerActions = new TreeViewerActions(treeViewer);
            actionGroupManager.addGroup(treeViewerActions);
        }
    }

    protected void contributeAdditionalActions(ActionGroupManager actionGroupManager) {
    }

    protected abstract IContentProvider createContentProvider();

    protected void createContextMenu(StructuredViewer structuredViewer) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                GridModelViewPart.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(structuredViewer.getControl());
        structuredViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)structuredViewer);
    }

    protected void createContextMenuGroups(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("group.new"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.goto"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.open"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.openWith"));
        iMenuManager.add((IContributionItem)new Separator("group.edit"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.show"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.port"));
        iMenuManager.add((IContributionItem)new Separator("group.generate"));
        iMenuManager.add((IContributionItem)new Separator("group.search"));
        iMenuManager.add((IContributionItem)new Separator("group.build"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("group.properties"));
    }

    protected abstract IBaseLabelProvider createLabelProvider();

    protected abstract StructuredViewer createViewer(Composite var1);

    protected void fillActionBars(ActionGroup actionGroup) {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        actionGroup.fillActionBars(iActionBars);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        ISelection iSelection = this.viewer.getSelection();
        ActionContext actionContext = new ActionContext(iSelection);
        this.createContextMenuGroups(iMenuManager);
        this.actions.setContext(actionContext);
        this.actions.fillContextMenu(iMenuManager);
        this.actions.setContext(null);
    }

    protected abstract IGridElement getRootElement();

    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        if (this.viewer instanceof TreeViewer) {
            Object object;
            TreeViewer treeViewer = (TreeViewer)this.viewer;
            ISelection iSelection = doubleClickEvent.getSelection();
            if (iSelection instanceof IStructuredSelection && treeViewer.isExpandable(object = ((IStructuredSelection)iSelection).getFirstElement())) {
                boolean bl = treeViewer.getExpandedState(object);
                treeViewer.setExpandedState(object, !bl);
            }
        }
    }

    protected void handleOpen(OpenEvent openEvent) {
        this.openActions.delegateOpenEvent(openEvent);
    }

    protected void initDragAndDrop(StructuredViewer structuredViewer) {
        this.initDrag(structuredViewer);
        this.initDrop(structuredViewer);
    }

    protected void initDrag(StructuredViewer structuredViewer) {
        int n = 19;
        DelegatingDragAdapter delegatingDragAdapter = new DelegatingDragAdapter();
        this.addDragSourceListeners(delegatingDragAdapter);
        structuredViewer.addDragSupport(n, delegatingDragAdapter.getTransfers(), (DragSourceListener)delegatingDragAdapter);
    }

    protected void initDrop(StructuredViewer structuredViewer) {
        int n = 19;
        DelegatingDropAdapter delegatingDropAdapter = new DelegatingDropAdapter();
        this.addDropTargetListeners(delegatingDropAdapter);
        structuredViewer.addDropSupport(n, delegatingDropAdapter.getTransfers(), (DropTargetListener)delegatingDropAdapter);
    }

    protected void initViewer(StructuredViewer structuredViewer) {
        structuredViewer.setLabelProvider(this.createLabelProvider());
        structuredViewer.setContentProvider(this.createContentProvider());
        structuredViewer.setInput((Object)this.getRootElement());
        this.registerViewerListeners(structuredViewer);
        this.initDragAndDrop(structuredViewer);
    }

    protected void registerViewerListeners(StructuredViewer structuredViewer) {
        structuredViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                GridModelViewPart.this.handleDoubleClick(doubleClickEvent);
            }
        });
        structuredViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                GridModelViewPart.this.handleOpen(openEvent);
            }
        });
    }
}

