/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views;

import eu.geclipse.core.monitoring.GridProcessMonitor;
import eu.geclipse.ui.providers.ProcessViewContentprovider;
import eu.geclipse.ui.providers.ProcessViewLabelProvider;
import eu.geclipse.ui.views.Messages;
import java.net.URI;
import java.util.HashSet;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class ProcessStatView
extends ViewPart
implements IContentChangeListener {
    TreeViewer viewer;
    Action updateAction;
    Action doubleClickAction;
    Action removeAction;
    Action dropJobAction;
    HashSet<GridProcessMonitor> remoteMonitors = new HashSet();
    private DrillDownAdapter drillDownAdapter;

    public void createPartControl(Composite composite) {
        this.viewer = new TreeViewer(composite, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ProcessViewContentprovider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProcessViewLabelProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ProcessStatView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.updateAction);
        iMenuManager.add((IContributionItem)new Separator());
    }

    void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.updateAction);
        iMenuManager.add((IAction)this.removeAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.updateAction);
        iToolBarManager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(iToolBarManager);
    }

    private void makeActions() {
        this.updateAction = new Action(){

            public void run() {
                ProcessStatView.this.viewer.refresh();
            }
        };
        this.updateAction.setText(Messages.getString("ProcessStatView.update"));
        this.updateAction.setToolTipText(Messages.getString("ProcessStatView.updatestat"));
        this.updateAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection iSelection = ProcessStatView.this.viewer.getSelection();
                Object object = ((IStructuredSelection)iSelection).getFirstElement();
                try {
                    Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {}
                ProcessStatView.this.viewer.refresh();
            }
        };
        this.removeAction = new Action(){

            public void run() {
                ISelection iSelection = ProcessStatView.this.viewer.getSelection();
                Object object = ((IStructuredSelection)iSelection).getFirstElement();
                if (object != null && object instanceof GridProcessMonitor) {
                    GridProcessMonitor gridProcessMonitor = (GridProcessMonitor)object;
                    ProcessStatView.this.removeMonitor(gridProcessMonitor);
                    ProcessStatView.this.viewer.refresh();
                }
            }
        };
        this.removeAction.setText(Messages.getString("ProcessStatView.remove"));
        this.removeAction.setToolTipText(Messages.getString("ProcessStatView.removemon"));
        this.removeAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void addSite(URI uRI) {
        if (uRI != null) {
            GridProcessMonitor gridProcessMonitor = new GridProcessMonitor(uRI);
            gridProcessMonitor.setUpdateInterval(5);
            this.remoteMonitors.add(gridProcessMonitor);
            this.viewer.setInput(this.remoteMonitors);
            this.viewer.refresh();
        }
    }

    public void removeSite(URI uRI) {
        if (uRI != null) {
            this.remoteMonitors.remove(new GridProcessMonitor(uRI));
            this.viewer.refresh();
        }
    }

    public void removeMonitor(GridProcessMonitor gridProcessMonitor) {
        if (gridProcessMonitor != null) {
            this.remoteMonitors.remove(gridProcessMonitor);
            this.viewer.refresh();
        }
    }

    protected void initializeBrowser() {
        this.viewer.setInput(this.remoteMonitors);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ProcessStatView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void contentChanged(IContentChangeNotifier iContentChangeNotifier) {
        this.viewer.refresh();
        System.out.println("content changed");
    }
}

