/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.filters;

import eu.geclipse.ui.views.filters.IGridFilter;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGridFilterConfiguration
implements IGridFilterConfiguration {
    private static final String MEMENTO_KEY_ENABLED = "Enabled";
    private static final String MEMENTO_KEY_TYPE = "Filter";
    protected ArrayList<IGridFilter> filtersList = new ArrayList();
    private String name;
    private boolean enabled = false;

    public AbstractGridFilterConfiguration(String string) {
        this.name = string;
    }

    @Override
    public IGridFilterConfiguration clone() throws CloneNotSupportedException {
        AbstractGridFilterConfiguration abstractGridFilterConfiguration = (AbstractGridFilterConfiguration)super.clone();
        abstractGridFilterConfiguration.filtersList = new ArrayList();
        for (IGridFilter iGridFilter : this.filtersList) {
            abstractGridFilterConfiguration.filtersList.add(iGridFilter.makeClone());
        }
        return abstractGridFilterConfiguration;
    }

    @Override
    public void read(IMemento iMemento) {
        Integer n = iMemento.getInteger(MEMENTO_KEY_ENABLED);
        if (n != null) {
            this.enabled = n != 0;
        }
        IMemento[] iMementoArray = iMemento.getChildren(MEMENTO_KEY_TYPE);
        int n2 = iMementoArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IMemento iMemento2 = iMementoArray[n3];
            IGridFilter iGridFilter = this.findFilter(iMemento2.getID());
            if (iGridFilter != null) {
                iGridFilter.readState(iMemento2);
            }
            ++n3;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public List<IGridFilter> getFilters() {
        return this.filtersList;
    }

    @Override
    public void saveState(IMemento iMemento) {
        iMemento.putInteger(MEMENTO_KEY_ENABLED, this.enabled ? 1 : 0);
        for (IGridFilter iGridFilter : this.filtersList) {
            IMemento iMemento2 = iMemento.createChild(MEMENTO_KEY_TYPE, iGridFilter.getFilterId());
            iGridFilter.saveState(iMemento2);
        }
    }

    protected void addFilter(IGridFilter iGridFilter) {
        this.filtersList.add(iGridFilter);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    protected IGridFilter findFilter(String string) {
        IGridFilter iGridFilter = null;
        Iterator<IGridFilter> iterator = this.filtersList.iterator();
        while (iterator.hasNext() && iGridFilter == null) {
            IGridFilter iGridFilter2 = iterator.next();
            if (!iGridFilter2.getFilterId().equals(string)) continue;
            iGridFilter = iGridFilter2;
        }
        return iGridFilter;
    }
}

