/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.filters;

import eu.geclipse.ui.dialogs.ConfigureFiltersDialog;
import eu.geclipse.ui.views.filters.IFilterConfigurationListener;
import eu.geclipse.ui.views.filters.IGridFilter;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GridFilterConfigurationsManager {
    public static final String ID_JOBVIEW = "JobView";
    private static final String MEMENTO_TYPE_CONFIGURATIONS_LIST = "FilterConfigurationsList";
    private static final String MEMENTO_TYPE_CONFIGURATION = "FilterConfiguration";
    private String id;
    private List<IGridFilterConfiguration> configurations = new ArrayList<IGridFilterConfiguration>();
    private List<IFilterConfigurationListener> listeners = new ArrayList<IFilterConfigurationListener>();

    public GridFilterConfigurationsManager(String string) {
        this.id = string;
    }

    public abstract IGridFilterConfiguration createConfiguration(String var1);

    public void saveState(IMemento iMemento) {
        if (iMemento != null && !this.configurations.isEmpty()) {
            IMemento iMemento2 = iMemento.createChild(this.getMementoTypeName());
            for (IGridFilterConfiguration iGridFilterConfiguration : this.configurations) {
                IMemento iMemento3 = iMemento2.createChild(MEMENTO_TYPE_CONFIGURATION, iGridFilterConfiguration.getName());
                iGridFilterConfiguration.saveState(iMemento3);
            }
        }
    }

    public void readState(IMemento iMemento) {
        IMemento iMemento2;
        this.configurations.clear();
        if (iMemento != null && (iMemento2 = iMemento.getChild(this.getMementoTypeName())) != null) {
            IMemento[] iMementoArray = iMemento2.getChildren(MEMENTO_TYPE_CONFIGURATION);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento iMemento3 = iMementoArray[n2];
                String string = iMemento3.getID();
                if (string != null) {
                    IGridFilterConfiguration iGridFilterConfiguration = this.createConfiguration(string);
                    iGridFilterConfiguration.read(iMemento3);
                    this.configurations.add(iGridFilterConfiguration);
                }
                ++n2;
            }
        }
        this.fireConfigurationChanged();
        this.fireFilterConfigurationSelected();
    }

    public ViewerFilter[] getEnabledFilters() {
        ArrayList<ViewerFilter> arrayList = new ArrayList<ViewerFilter>();
        for (IGridFilterConfiguration iGridFilterConfiguration : this.configurations) {
            if (!iGridFilterConfiguration.isEnabled()) continue;
            for (IGridFilter iGridFilter : iGridFilterConfiguration.getFilters()) {
                if (!iGridFilter.isEnabled()) continue;
                arrayList.add(iGridFilter.getFilter());
            }
        }
        return arrayList.toArray(new ViewerFilter[arrayList.size()]);
    }

    private String getMementoTypeName() {
        return "FilterConfigurationsList." + this.id;
    }

    public final List<IGridFilterConfiguration> getConfigurations() {
        return this.configurations;
    }

    public boolean configure(Shell shell) {
        boolean bl = false;
        ConfigureFiltersDialog configureFiltersDialog = new ConfigureFiltersDialog(shell, this);
        if (configureFiltersDialog.open() == 0) {
            this.configurations = configureFiltersDialog.getConfigurations();
            bl = true;
            this.fireConfigurationChanged();
            this.fireFilterConfigurationSelected();
        }
        return bl;
    }

    public void enableConfiguration(IGridFilterConfiguration iGridFilterConfiguration) {
        for (IGridFilterConfiguration iGridFilterConfiguration2 : this.configurations) {
            iGridFilterConfiguration2.setEnabled(iGridFilterConfiguration2 == iGridFilterConfiguration);
        }
        this.fireFilterConfigurationSelected();
    }

    public void addConfigurationListener(IFilterConfigurationListener iFilterConfigurationListener) {
        if (!this.listeners.contains(iFilterConfigurationListener)) {
            this.listeners.add(iFilterConfigurationListener);
        }
    }

    public void removeConfigurationListener(IFilterConfigurationListener iFilterConfigurationListener) {
        this.listeners.remove(iFilterConfigurationListener);
    }

    private void fireConfigurationChanged() {
        for (IFilterConfigurationListener iFilterConfigurationListener : this.listeners) {
            iFilterConfigurationListener.configurationChanged();
        }
    }

    private void fireFilterConfigurationSelected() {
        ViewerFilter[] viewerFilterArray = this.getEnabledFilters();
        for (IFilterConfigurationListener iFilterConfigurationListener : this.listeners) {
            iFilterConfigurationListener.filterConfigurationSelected(viewerFilterArray);
        }
    }
}

