/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.filters;

import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.views.filters.AbstractGridViewerFilter;
import eu.geclipse.ui.views.filters.IGridFilter;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;

public class JobStatusFilter
extends AbstractGridViewerFilter {
    private static final String MEMENTO_TYPE_STATUS = "Status";
    private static final String MEMENTO_KEY_STATUS_SHOW = "Show";
    private HashMap<Integer, Boolean> statusMap = new HashMap();

    public IGridFilter makeClone() throws CloneNotSupportedException {
        JobStatusFilter jobStatusFilter = (JobStatusFilter)super.clone();
        jobStatusFilter.statusMap = (HashMap)this.statusMap.clone();
        return jobStatusFilter;
    }

    public void setStatusState(int n, boolean bl) {
        this.statusMap.put(n, bl);
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        boolean bl = true;
        if (object2 instanceof IGridJob) {
            IGridJob iGridJob = (IGridJob)object2;
            int n = iGridJob.getJobStatus().getType();
            Boolean bl2 = this.statusMap.get(n);
            bl = bl2 == null ? this.getStatusState(128) : bl2.booleanValue();
        }
        return bl;
    }

    public boolean getStatusState(int n) {
        Boolean bl = this.statusMap.get(n);
        return bl == null || bl != false;
    }

    public void saveState(IMemento iMemento) {
        for (Integer n : this.statusMap.keySet()) {
            IMemento iMemento2 = iMemento.createChild(MEMENTO_TYPE_STATUS, n.toString());
            iMemento2.putInteger(MEMENTO_KEY_STATUS_SHOW, this.getStatusState(n) ? 1 : 0);
        }
    }

    public boolean isEnabled() {
        boolean bl = false;
        Iterator<Integer> iterator = this.statusMap.keySet().iterator();
        while (iterator.hasNext() && !bl) {
            bl |= this.statusMap.get(iterator.next()) == false;
        }
        return bl;
    }

    public void readState(IMemento iMemento) {
        IMemento[] iMementoArray;
        IMemento[] iMementoArray2 = iMementoArray = iMemento.getChildren(MEMENTO_TYPE_STATUS);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento iMemento2 = iMementoArray2[n2];
            Integer n3 = Integer.valueOf(iMemento2.getID());
            Integer n4 = iMemento2.getInteger(MEMENTO_KEY_STATUS_SHOW);
            if (n3 != null && n4 != null) {
                this.setStatusState(n3, n4 != 0);
            }
            ++n2;
        }
    }

    static String getId() {
        return "JobStatusFilter";
    }

    public String getFilterId() {
        return JobStatusFilter.getId();
    }
}

