/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.filters;

import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.views.filters.AbstractGridViewerFilter;
import eu.geclipse.ui.views.filters.IGridFilter;
import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;

public class JobSubmissionTimeFilter
extends AbstractGridViewerFilter {
    private static String MEMENTO_KEY_AFTERDATE = "AfterDate";
    private static String MEMENTO_KEY_BEFOREDATE = "BeforeDate";
    private Date afterDate;
    private Date beforeDate;

    public boolean select(Viewer viewer, Object object, Object object2) {
        IGridJob iGridJob;
        boolean bl = true;
        if (object2 instanceof IGridJob && (iGridJob = (IGridJob)object2).getSubmissionTime() != null) {
            if (this.afterDate != null) {
                bl &= iGridJob.getSubmissionTime().after(this.afterDate);
            }
            if (this.beforeDate != null) {
                bl &= iGridJob.getSubmissionTime().before(this.beforeDate);
            }
        }
        return bl;
    }

    public String getFilterId() {
        return JobSubmissionTimeFilter.getId();
    }

    public boolean isEnabled() {
        return this.afterDate != null || this.beforeDate != null;
    }

    public IGridFilter makeClone() throws CloneNotSupportedException {
        JobSubmissionTimeFilter jobSubmissionTimeFilter = (JobSubmissionTimeFilter)super.clone();
        if (this.afterDate != null) {
            jobSubmissionTimeFilter.afterDate = (Date)this.afterDate.clone();
        }
        if (this.beforeDate != null) {
            jobSubmissionTimeFilter.beforeDate = (Date)this.beforeDate.clone();
        }
        return jobSubmissionTimeFilter;
    }

    public void readState(IMemento iMemento) {
        this.afterDate = this.readDate(iMemento, MEMENTO_KEY_AFTERDATE);
        this.beforeDate = this.readDate(iMemento, MEMENTO_KEY_BEFOREDATE);
    }

    public void saveState(IMemento iMemento) {
        if (this.afterDate != null) {
            this.saveDate(iMemento, MEMENTO_KEY_AFTERDATE, this.afterDate);
        }
        if (this.beforeDate != null) {
            this.saveDate(iMemento, MEMENTO_KEY_BEFOREDATE, this.beforeDate);
        }
    }

    static String getId() {
        return "JobSubmissionTimeFilter";
    }

    public void setDates(Date date, Date date2) {
        this.afterDate = date;
        this.beforeDate = date2;
    }

    public Date getAfterDate() {
        return this.afterDate;
    }

    public Date getBeforeDate() {
        return this.beforeDate;
    }
}

