/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.jobdetails;

import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.views.jobdetails.IJobDetail;
import eu.geclipse.ui.views.jobdetails.IJobDetailsFactory;
import eu.geclipse.ui.views.jobdetails.JobDetailSectionsManager;
import eu.geclipse.ui.views.jobdetails.JobTextDetail;
import eu.geclipse.ui.views.jobdetails.Messages;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridJobDetailsFactory
implements IJobDetailsFactory {
    @Override
    public List<IJobDetail> getDetails(IGridJob iGridJob, JobDetailSectionsManager jobDetailSectionsManager) {
        ArrayList<IJobDetail> arrayList = new ArrayList<IJobDetail>(20);
        arrayList.add(this.createName(jobDetailSectionsManager));
        arrayList.add(this.createIdentifier(jobDetailSectionsManager));
        arrayList.add(this.createStatus(jobDetailSectionsManager));
        arrayList.add(this.createReason(jobDetailSectionsManager));
        arrayList.add(this.createStatusUpdatedTime(jobDetailSectionsManager));
        arrayList.add(this.createExecutable(jobDetailSectionsManager));
        arrayList.add(this.createExecArgs(jobDetailSectionsManager));
        arrayList.add(this.createInput(jobDetailSectionsManager));
        arrayList.add(this.createOutput(jobDetailSectionsManager));
        return arrayList;
    }

    private IJobDetail createName(JobDetailSectionsManager jobDetailSectionsManager) {
        return new JobTextDetail(jobDetailSectionsManager.getSectionGeneral(), Messages.GridJobDetailsFactory_name){

            protected String getValue(IGridJob iGridJob) {
                return iGridJob.getName();
            }
        };
    }

    private IJobDetail createIdentifier(JobDetailSectionsManager jobDetailSectionsManager) {
        return new JobTextDetail(jobDetailSectionsManager.getSectionGeneral(), Messages.GridJobDetailsFactory_id){

            protected String getValue(IGridJob iGridJob) {
                String string = null;
                if (iGridJob.getID() != null) {
                    string = iGridJob.getID().getJobID();
                }
                return string;
            }
        };
    }

    private IJobDetail createStatus(JobDetailSectionsManager jobDetailSectionsManager) {
        return new JobTextDetail(jobDetailSectionsManager.getSectionGeneral(), Messages.GridJobDetailsFactory_status){

            protected String getValue(IGridJob iGridJob) {
                String string = null;
                if (iGridJob.getJobStatus() != null) {
                    string = iGridJob.getJobStatus().getName();
                }
                return string;
            }
        };
    }

    private IJobDetail createReason(JobDetailSectionsManager jobDetailSectionsManager) {
        return new JobTextDetail(jobDetailSectionsManager.getSectionGeneral(), Messages.GridJobDetailsFactory_reason){

            protected String getValue(IGridJob iGridJob) {
                String string = null;
                if (iGridJob.getJobStatus() != null && iGridJob.getJobStatus().getReason() != null && iGridJob.getJobStatus().getReason().length() > 0) {
                    string = iGridJob.getJobStatus().getReason();
                }
                return string;
            }
        };
    }

    private IJobDetail createStatusUpdatedTime(JobDetailSectionsManager jobDetailSectionsManager) {
        return new JobTextDetail(jobDetailSectionsManager.getSectionGeneral(), Messages.GridJobDetailsFactory_lastUpdateTime){

            protected String getValue(IGridJob iGridJob) {
                String string = null;
                if (iGridJob.getJobStatus() != null && iGridJob.getJobStatus().getLastUpdateTime() != null) {
                    string = DateFormat.getDateTimeInstance().format(iGridJob.getJobStatus().getLastUpdateTime());
                }
                return string;
            }
        };
    }

    private IJobDetail createExecutable(JobDetailSectionsManager jobDetailSectionsManager) {
        return new JobTextDetail(jobDetailSectionsManager.getSectionApplication(), Messages.GridJobDetailsFactory_executable){

            protected String getValue(IGridJob iGridJob) {
                String string = null;
                if (iGridJob.getJobDescription() != null) {
                    string = iGridJob.getJobDescription().getExecutable();
                }
                return string;
            }
        };
    }

    private IJobDetail createExecArgs(JobDetailSectionsManager jobDetailSectionsManager) {
        return new JobTextDetail(jobDetailSectionsManager.getSectionApplication(), Messages.GridJobDetailsFactory_arguments){

            protected String getValue(IGridJob iGridJob) {
                String string = null;
                if (iGridJob.getJobDescription() != null && iGridJob.getJobDescription().getExecutableArguments() != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    List list = iGridJob.getJobDescription().getExecutableArguments();
                    for (String string2 : list) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(string2);
                    }
                    string = stringBuilder.toString();
                }
                return string;
            }
        };
    }

    private IJobDetail createInput(JobDetailSectionsManager jobDetailSectionsManager) {
        return new JobTextDetail(jobDetailSectionsManager.getSectionApplication(), Messages.GridJobDetailsFactory_input){

            protected String getValue(IGridJob iGridJob) {
                String string = null;
                if (iGridJob.getJobDescription() != null) {
                    string = iGridJob.getJobDescription().getInput();
                }
                return string;
            }
        };
    }

    private IJobDetail createOutput(JobDetailSectionsManager jobDetailSectionsManager) {
        return new JobTextDetail(jobDetailSectionsManager.getSectionApplication(), Messages.GridJobDetailsFactory_output){

            protected String getValue(IGridJob iGridJob) {
                String string = null;
                if (iGridJob.getJobDescription() != null) {
                    string = iGridJob.getJobDescription().getOutput();
                }
                return string;
            }
        };
    }
}

