/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.jobdetails;

import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.Extensions;
import eu.geclipse.ui.views.jobdetails.IJobDetail;
import eu.geclipse.ui.views.jobdetails.IJobDetailsFactory;
import eu.geclipse.ui.views.jobdetails.IJobDetailsSection;
import eu.geclipse.ui.views.jobdetails.IViewConfiguration;
import eu.geclipse.ui.views.jobdetails.JobDetailsSection;
import eu.geclipse.ui.views.jobdetails.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobDetailSectionsManager {
    private static int nextId = 1;
    private static Integer generalSectionId;
    private static Integer applicationSectionId;
    private Composite parent;
    private Map<Integer, IJobDetailsSection> sectionsMap = new HashMap<Integer, IJobDetailsSection>();
    private List<IJobDetail> currentDetails;

    public JobDetailSectionsManager(Composite composite) {
        this.parent = composite;
    }

    private static int getNextId() {
        return nextId++;
    }

    void refresh(IGridJob iGridJob, IViewConfiguration iViewConfiguration) {
        List<IJobDetail> list = this.getDetails(iGridJob);
        List<IJobDetailsSection> list2 = this.getSections(list);
        this.disposeNotUsedDetails(list);
        this.dispatchDetailsToSections(list);
        this.disposeNotUsedSections();
        for (IJobDetailsSection iJobDetailsSection : list2) {
            iJobDetailsSection.refresh(iGridJob, this.parent, iViewConfiguration);
        }
        this.currentDetails = list;
    }

    private List<IJobDetail> getDetails(IGridJob iGridJob) {
        ArrayList<IJobDetail> arrayList = new ArrayList<IJobDetail>(100);
        if (iGridJob != null) {
            Class<?> clazz = iGridJob.getJobStatus() != null ? iGridJob.getJobStatus().getClass() : null;
            List<IJobDetailsFactory> list = Extensions.getJobDetailsFactories(iGridJob.getClass(), clazz);
            for (IJobDetailsFactory iJobDetailsFactory : list) {
                arrayList.addAll(iJobDetailsFactory.getDetails(iGridJob, this));
            }
        }
        return arrayList;
    }

    private List<IJobDetailsSection> getSections(List<IJobDetail> list) {
        ArrayList<IJobDetailsSection> arrayList = new ArrayList<IJobDetailsSection>();
        for (IJobDetail iJobDetail : list) {
            if (arrayList.contains(iJobDetail.getSection())) continue;
            arrayList.add(iJobDetail.getSection());
        }
        Collections.sort(arrayList, new Comparator<IJobDetailsSection>(){

            @Override
            public int compare(IJobDetailsSection iJobDetailsSection, IJobDetailsSection iJobDetailsSection2) {
                return iJobDetailsSection.getOrder() - iJobDetailsSection2.getOrder();
            }
        });
        return arrayList;
    }

    public IJobDetailsSection getSection(Integer n) {
        return this.sectionsMap.get(n);
    }

    public Integer createSection(String string, int n) {
        Integer n2 = JobDetailSectionsManager.getNextId();
        JobDetailsSection jobDetailsSection = new JobDetailsSection(string, n);
        this.sectionsMap.put(n2, jobDetailsSection);
        return n2;
    }

    public IJobDetailsSection getSectionGeneral() {
        IJobDetailsSection iJobDetailsSection = this.getSection(generalSectionId);
        if (iJobDetailsSection == null) {
            generalSectionId = this.createSection(Messages.JobDetailSectionsManager_general, SectionOrder.GENERAL.getOrder());
            iJobDetailsSection = this.getSection(generalSectionId);
        }
        return iJobDetailsSection;
    }

    public IJobDetailsSection getSectionApplication() {
        IJobDetailsSection iJobDetailsSection = this.getSection(applicationSectionId);
        if (iJobDetailsSection == null) {
            applicationSectionId = this.createSection(Messages.JobDetailSectionsManager_application, SectionOrder.APPLICATION.getOrder());
            iJobDetailsSection = this.getSection(applicationSectionId);
        }
        return iJobDetailsSection;
    }

    private void dispatchDetailsToSections(List<IJobDetail> list) {
        if (list != null) {
            for (IJobDetail iJobDetail : list) {
                iJobDetail.getSection().addDetail(iJobDetail);
            }
        }
    }

    private void disposeNotUsedDetails(List<IJobDetail> list) {
        if (this.currentDetails != null) {
            for (IJobDetail iJobDetail : this.currentDetails) {
                if (this.findDetailById(list, iJobDetail.getId(), iJobDetail.getSection()) != null) continue;
                iJobDetail.dispose();
                iJobDetail.getSection().removeDetail(iJobDetail);
            }
        }
    }

    private void disposeNotUsedSections() {
        for (Integer n : this.sectionsMap.keySet()) {
            IJobDetailsSection iJobDetailsSection = this.getSection(n);
            if (iJobDetailsSection == null || iJobDetailsSection.getDetails().size() != 0) continue;
            iJobDetailsSection.dispose();
        }
    }

    private IJobDetail findDetailById(List<IJobDetail> list, String string, IJobDetailsSection iJobDetailsSection) {
        IJobDetail iJobDetail = null;
        Iterator<IJobDetail> iterator = list.iterator();
        while (iterator.hasNext() && iJobDetail == null) {
            IJobDetail iJobDetail2 = iterator.next();
            if (iJobDetail2.getSection() != iJobDetailsSection || !iJobDetail2.getId().equals(string)) continue;
            iJobDetail = iJobDetail2;
        }
        return iJobDetail;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SectionOrder {
        GENERAL,
        APPLICATION;


        int getOrder() {
            return this.ordinal();
        }
    }
}

