/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.jobdetails;

import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.views.jobdetails.IJobDetail;
import eu.geclipse.ui.views.jobdetails.IJobDetailsSection;
import eu.geclipse.ui.views.jobdetails.IViewConfiguration;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobDetailsSection
implements IJobDetailsSection {
    private String name;
    private int order;
    private Section sectionWidget;
    private List<IJobDetail> details = new LinkedList<IJobDetail>();

    public JobDetailsSection(String string, int n) {
        this.name = string;
        this.order = n;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void refresh(IGridJob iGridJob, Composite composite, IViewConfiguration iViewConfiguration) {
        boolean bl = false;
        if (!this.isWidgetCreated()) {
            this.createWidgets(composite, iViewConfiguration.getFormToolkit());
        }
        for (IJobDetail iJobDetail : this.details) {
            bl |= iJobDetail.refresh(iGridJob, (Composite)this.sectionWidget.getClient(), iViewConfiguration);
        }
        this.setVisible(iViewConfiguration.isShowEmptyEnabled() || bl);
    }

    private void createWidgets(Composite composite, FormToolkit formToolkit) {
        this.sectionWidget = formToolkit.createSection(composite, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        this.sectionWidget.setLayoutData((Object)gridData);
        this.sectionWidget.setText(this.name);
        this.sectionWidget.setExpanded(true);
        Composite composite2 = formToolkit.createComposite((Composite)this.sectionWidget);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.sectionWidget.setClient((Control)composite2);
    }

    private boolean isWidgetCreated() {
        return this.sectionWidget != null && !this.sectionWidget.isDisposed();
    }

    @Override
    public void addDetail(IJobDetail iJobDetail) {
        IJobDetail iJobDetail2 = null;
        ListIterator<IJobDetail> listIterator = this.details.listIterator();
        while (listIterator.hasNext() && iJobDetail2 == null) {
            IJobDetail iJobDetail3 = listIterator.next();
            if (!iJobDetail3.getId().equals(iJobDetail.getId()) || !iJobDetail3.getClass().equals(iJobDetail.getClass())) continue;
            iJobDetail2 = iJobDetail3;
        }
        if (iJobDetail2 == null) {
            this.details.add(iJobDetail);
        } else {
            iJobDetail.reuseWidgets(iJobDetail2);
            listIterator.set(iJobDetail);
        }
    }

    @Override
    public void removeDetail(IJobDetail iJobDetail) {
        this.details.remove(iJobDetail);
    }

    @Override
    public void dispose() {
        if (this.isWidgetCreated()) {
            this.sectionWidget.dispose();
            this.sectionWidget = null;
        }
    }

    private void setVisible(boolean bl) {
        this.sectionWidget.setVisible(bl);
        GridData gridData = (GridData)this.sectionWidget.getLayoutData();
        gridData.exclude = !bl;
    }

    @Override
    public List<IJobDetail> getDetails() {
        return this.details;
    }
}

