/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.jobdetails;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobManager;
import eu.geclipse.core.model.IGridJobStatusListener;
import eu.geclipse.ui.internal.actions.JobDetailsViewActions;
import eu.geclipse.ui.views.jobdetails.IViewConfiguration;
import eu.geclipse.ui.views.jobdetails.JobDetailSectionsManager;
import eu.geclipse.ui.views.jobdetails.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class JobDetailsView
extends ViewPart
implements ISelectionListener,
IViewConfiguration,
IGridJobStatusListener {
    public static final String ID = "eu.geclipse.ui.views.jobdetails.JobDetailsView";
    private ScrolledForm topScrolledForm;
    private FormToolkit formToolkit;
    private JobDetailSectionsManager sectionsManager;
    private IMemento memento;
    private JobDetailsViewActions actions;
    private JobSelectionProvider jobSelectionProvider;
    private Label emptyJobDescription;
    private IGridJob inputJob;

    public FormToolkit getFormToolkit() {
        if (this.formToolkit == null) {
            this.formToolkit = new FormToolkit(Display.getCurrent());
        }
        return this.formToolkit;
    }

    public void createPartControl(Composite composite) {
        this.fillActionBars();
        this.fillContextMenu();
        this.readState();
        this.topScrolledForm = this.getFormToolkit().createScrolledForm(composite);
        this.topScrolledForm.getBody().setLayout((Layout)new GridLayout(2, false));
        this.topScrolledForm.setBackground(this.getFormToolkit().getColors().getBackground());
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.setInputJob(this.findSelectedJob());
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        GridModel.getJobManager().removeJobStatusListener((IGridJobStatusListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.topScrolledForm.setFocus();
    }

    protected void setInputJob(IGridJob iGridJob) {
        IGridJobManager iGridJobManager = GridModel.getJobManager();
        if (this.inputJob != null) {
            iGridJobManager.removeJobStatusListener((IGridJobStatusListener)this);
        }
        this.inputJob = iGridJob;
        if (this.inputJob != null) {
            iGridJobManager.addJobStatusListener(new IGridJob[]{this.inputJob}, 255, (IGridJobStatusListener)this);
        }
        this.refresh();
        this.getJobSelectionProvider().fireSelectionChanged();
    }

    public void refresh() {
        this.refreshEmptyJobDescription();
        this.getSectionsManager().refresh(this.inputJob, this);
        this.topScrolledForm.reflow(true);
    }

    private IGridJob findSelectedJob() {
        Object object;
        IGridJob iGridJob = null;
        ISelection iSelection = this.getSite().getPage().getSelection();
        if (iSelection != null && iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) != null && object instanceof IGridJob) {
            iGridJob = (IGridJob)object;
        }
        return iGridJob;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        Object object;
        IStructuredSelection iStructuredSelection;
        if (iSelection != null && iSelection instanceof IStructuredSelection && !(iStructuredSelection = (IStructuredSelection)iSelection).isEmpty() && (object = iStructuredSelection.getFirstElement()) instanceof IGridJob) {
            IGridJob iGridJob = (IGridJob)object;
            this.setInputJob(iGridJob);
        }
    }

    public boolean isShowEmptyEnabled() {
        return this.getActions().isShowEmptyEnabled();
    }

    public JobDetailSectionsManager getSectionsManager() {
        if (this.sectionsManager == null) {
            this.sectionsManager = new JobDetailSectionsManager(this.topScrolledForm.getBody());
        }
        return this.sectionsManager;
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        this.memento = iMemento;
        super.init(iViewSite, iMemento);
    }

    private void readState() {
        if (this.memento != null) {
            this.getActions().readState(this.memento);
        }
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
        this.getActions().saveState(iMemento);
    }

    public void statusChanged(final IGridJob iGridJob) {
        Display display;
        Shell shell;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite != null && (shell = iWorkbenchPartSite.getShell()) != null && (display = shell.getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    JobDetailsView.this.setInputJob(iGridJob);
                }
            });
        }
    }

    private JobDetailsViewActions getActions() {
        if (this.actions == null) {
            this.actions = new JobDetailsViewActions(this);
        }
        return this.actions;
    }

    private void fillActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.getActions().fillActionBars(iActionBars);
    }

    private void fillContextMenu() {
        IMenuManager iMenuManager = this.getViewSite().getActionBars().getMenuManager();
        this.getActions().fillContextMenu(iMenuManager);
    }

    public JobSelectionProvider getJobSelectionProvider() {
        if (this.jobSelectionProvider == null) {
            this.jobSelectionProvider = new JobSelectionProvider();
        }
        return this.jobSelectionProvider;
    }

    private void refreshEmptyJobDescription() {
        if (this.inputJob == null) {
            if (this.emptyJobDescription == null) {
                this.emptyJobDescription = this.getFormToolkit().createLabel(this.topScrolledForm.getBody(), Messages.JobDetailsView_emptyJobDescription);
            }
        } else if (this.emptyJobDescription != null) {
            this.emptyJobDescription.dispose();
            this.emptyJobDescription = null;
        }
    }

    IGridJob getInputJob() {
        return this.inputJob;
    }

    public class JobSelectionProvider
    implements ISelectionProvider {
        private List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();

        public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
            if (!this.selectionChangedListeners.contains(iSelectionChangedListener)) {
                this.selectionChangedListeners.add(iSelectionChangedListener);
            }
        }

        public ISelection getSelection() {
            return JobDetailsView.this.getInputJob() == null ? new StructuredSelection() : new StructuredSelection((Object)JobDetailsView.this.getInputJob());
        }

        public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
            this.selectionChangedListeners.remove(iSelectionChangedListener);
        }

        public void setSelection(ISelection iSelection) {
        }

        void fireSelectionChanged() {
            SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            for (ISelectionChangedListener iSelectionChangedListener : this.selectionChangedListeners) {
                iSelectionChangedListener.selectionChanged(selectionChangedEvent);
            }
        }
    }
}

