/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.widgets;

import eu.geclipse.core.GridException;
import eu.geclipse.core.IProblem;
import eu.geclipse.ui.DateTimeSolutionRegistry;
import eu.geclipse.ui.UIProblems;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.widgets.Messages;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DateTimeText {
    private static Image image;
    protected Style style;
    protected Button calendarButton;
    private Text text;
    private Composite topComposite;
    private boolean allowEmpty;

    public DateTimeText(Composite composite, Style style, boolean bl) {
        this.style = style;
        this.allowEmpty = bl;
        this.topComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.topComposite.setLayout((Layout)gridLayout);
        this.createText(this.topComposite);
        this.createButton(this.topComposite);
    }

    public void setDate(Date date) {
        String string = "";
        if (date != null) {
            string = this.getFormatter(this.style).format(date);
        }
        this.text.setText(string);
    }

    public Date getDate() throws GridException {
        Date date = null;
        try {
            date = this.internalGetDate();
        }
        catch (ParseException parseException) {
            GridException gridException = new GridException(UIProblems.DATETIME_PARSE_PROBLEM);
            IProblem iProblem = gridException.getProblem();
            iProblem.addSolution(DateTimeSolutionRegistry.getRegistry().findSolution(DateTimeSolutionRegistry.USE_CALENDAR_BUTTON, this));
            iProblem.addSolution(DateTimeSolutionRegistry.getRegistry().findSolution(DateTimeSolutionRegistry.APPLY_VALID_DATEFORMAT, this));
            if (this.allowEmpty) {
                iProblem.addSolution(DateTimeSolutionRegistry.getRegistry().findSolution(DateTimeSolutionRegistry.DELETE_ENTERED_DATE, this));
            }
            throw gridException;
        }
        return date;
    }

    public String getValidDateFormat() {
        String string = null;
        try {
            string = ((SimpleDateFormat)this.getFormatter(this.style)).toLocalizedPattern();
        }
        catch (ClassCastException classCastException) {}
        return string;
    }

    private DateFormat getFormatter(Style style) {
        DateFormat dateFormat = null;
        switch (style) {
            case DATE: {
                dateFormat = DateFormat.getDateInstance();
                break;
            }
            default: {
                dateFormat = DateFormat.getDateTimeInstance();
            }
        }
        dateFormat.setLenient(true);
        return dateFormat;
    }

    private void createText(Composite composite) {
        this.text = new Text(composite, 2052);
        GridData gridData = new GridData();
        gridData.widthHint = this.getWidthHint();
        this.text.setLayoutData((Object)gridData);
    }

    private int getWidthHint() {
        int n = -1;
        switch (this.style) {
            case DATE: {
                n = -1;
                break;
            }
            default: {
                n = 110;
            }
        }
        return n;
    }

    private Date internalGetDate() throws ParseException {
        Date date;
        block3: {
            date = null;
            DateFormat dateFormat = this.getFormatter(this.style);
            String string = this.text.getText();
            if (!this.allowEmpty || string.length() > 0) {
                try {
                    date = dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    date = this.parseOtherFormats(string);
                    if (date != null) break block3;
                    throw parseException;
                }
            }
        }
        return date;
    }

    private Date parseOtherFormats(String string) {
        Date date = null;
        DateFormat[] dateFormatArray = new DateFormat[]{DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateInstance()};
        int n = 0;
        while (n < dateFormatArray.length && date == null) {
            try {
                date = dateFormatArray[n].parse(string);
            }
            catch (ParseException parseException) {}
            ++n;
        }
        return date;
    }

    private void createButton(Composite composite) {
        this.calendarButton = new Button(composite, 8);
        this.calendarButton.setImage(this.getImage());
        this.calendarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DateTimeText.this.openCalendarDialog();
            }
        });
    }

    private Image getImage() {
        if (image == null) {
            ImageDescriptor imageDescriptor = Activator.getDefault().getImageRegistry().getDescriptor("calendar");
            image = imageDescriptor.createImage();
        }
        return image;
    }

    public Shell getShell() {
        return this.topComposite.getShell();
    }

    public void openCalendarDialog() {
        DateTimeDialog dateTimeDialog = new DateTimeDialog(this.getShell());
        dateTimeDialog.open();
    }

    public void setEnabled(boolean bl) {
        this.text.setEnabled(bl);
        this.calendarButton.setEnabled(bl);
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }

    private class DateTimeDialog
    extends PopupDialog {
        private DateTime dateControl;
        private DateTime timeControl;

        protected DateTimeDialog(Shell shell) {
            super(shell, 8, true, false, false, false, null, null);
        }

        private void setDate(Date date) {
            if (date != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                this.dateControl.setYear(calendar.get(1));
                this.dateControl.setMonth(calendar.get(2));
                this.dateControl.setDay(calendar.get(5));
                if (this.timeControl != null) {
                    this.timeControl.setHours(calendar.get(11));
                    this.timeControl.setMinutes(calendar.get(12));
                    this.timeControl.setSeconds(calendar.get(13));
                }
            }
        }

        private Date getDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.dateControl.getYear(), this.dateControl.getMonth(), this.dateControl.getDay(), this.timeControl == null ? 0 : this.timeControl.getHours(), this.timeControl == null ? 0 : this.timeControl.getMinutes(), this.timeControl == null ? 0 : this.timeControl.getSeconds());
            return calendar.getTime();
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout(2, true));
            this.createCalendar(composite2);
            if (DateTimeText.this.style == Style.DATETIME) {
                this.createHour(composite2);
            }
            this.createButtons(composite2);
            try {
                this.setDate(DateTimeText.this.getDate());
            }
            catch (GridException gridException) {}
            return composite2;
        }

        private void createButtons(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 131072;
            gridData.horizontalSpan = 2;
            composite2.setLayoutData((Object)gridData);
            this.createOkButton(composite2);
            this.createCancelButton(composite2);
        }

        private void createCalendar(Composite composite) {
            this.dateControl = new DateTime(composite, 1024);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.dateControl.setLayoutData((Object)gridData);
        }

        private void createHour(Composite composite) {
            Label label = new Label(composite, 0);
            label.setText(Messages.getString("DateTimeText.labelHour"));
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 0x1000008;
            label.setLayoutData((Object)gridData);
            this.timeControl = new DateTime(composite, 128);
            gridData = new GridData();
            gridData.horizontalAlignment = 131072;
            this.timeControl.setLayoutData((Object)gridData);
        }

        protected Point getInitialLocation(Point point) {
            return Display.getCurrent().map((Control)DateTimeText.this.calendarButton.getParent(), null, DateTimeText.this.calendarButton.getLocation());
        }

        private void createOkButton(Composite composite) {
            Button button = new Button(composite, 0x800008);
            button.setText(IDialogConstants.OK_LABEL);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 131072;
            gridData.widthHint = 61;
            button.setLayoutData((Object)gridData);
            this.getShell().setDefaultButton(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DateTimeDialog.this.closeWithSave();
                }
            });
        }

        private void createCancelButton(Composite composite) {
            Button button = new Button(composite, 0x800008);
            button.setText(IDialogConstants.CANCEL_LABEL);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 131072;
            gridData.widthHint = 61;
            button.setLayoutData((Object)gridData);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DateTimeDialog.this.close();
                }
            });
        }

        protected void closeWithSave() {
            DateTimeText.this.setDate(this.getDate());
            this.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        DATE,
        DATETIME;

    }
}

