/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.widgets;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class StoredCombo
extends Combo {
    private static final String prefSeparator = "\u001e";
    private static String LAST_ITEM_PREFIX = "_last";
    protected boolean allowCompletion = true;
    private IPreferenceStore prefStore = null;
    private String prefID;

    public StoredCombo(Composite composite, int n) {
        super(composite, n);
        this.addModifyListener(new ModifyListener(){
            private boolean alreadyModifing = false;

            public void modifyText(ModifyEvent modifyEvent) {
                if (!this.alreadyModifing && StoredCombo.this.allowCompletion) {
                    this.alreadyModifing = true;
                    StoredCombo.this.doAutoCompletion();
                    this.alreadyModifing = false;
                }
            }
        });
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                StoredCombo.this.allowCompletion = false;
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.character) {
                    case '\b': 
                    case '\u007f': {
                        StoredCombo.this.allowCompletion = false;
                        break;
                    }
                    default: {
                        StoredCombo.this.allowCompletion = true;
                    }
                }
            }
        });
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                Combo combo = (Combo)focusEvent.widget;
                String string = combo.getText();
                combo.setSelection(new Point(string.length(), string.length()));
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                StoredCombo.this.savePreferences();
            }
        });
    }

    public void setPreferences(IPreferenceStore iPreferenceStore, String string) {
        this.removeAll();
        this.prefStore = iPreferenceStore;
        this.prefID = string;
        if (this.prefStore != null) {
            String string2;
            String[] stringArray;
            String string3 = this.prefStore.getString(this.prefID);
            String[] stringArray2 = stringArray = string3.split(prefSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string2 = stringArray2[n2];
                if (this.isValidItem(string2)) {
                    this.add(string2);
                }
                ++n2;
            }
            string2 = this.prefStore.getString(String.valueOf(this.prefID) + LAST_ITEM_PREFIX);
            if (this.isValidItem(string2)) {
                n2 = this.allowCompletion ? 1 : 0;
                this.allowCompletion = false;
                this.setText(string2);
                this.allowCompletion = n2;
            }
        }
    }

    public boolean setDefaultItem(String string) {
        boolean bl = this.isValidItem(string);
        if (bl) {
            boolean bl2 = this.allowCompletion;
            this.allowCompletion = false;
            this.setText(string);
            this.allowCompletion = bl2;
        }
        return bl;
    }

    protected void doAutoCompletion() {
        String string = this.getText();
        if (string.length() > 0) {
            String[] stringArray;
            String string2 = null;
            String[] stringArray2 = stringArray = this.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = stringArray2[n2];
                if (string3.startsWith(string) && (string2 == null || string3.length() < string2.length())) {
                    string2 = string3;
                }
                ++n2;
            }
            if (string2 != null) {
                this.setText(string2);
                this.setSelection(new Point(string.length(), string2.length()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void savePreferences() {
        if (this.prefStore != null) {
            CharSequence charSequence;
            void string2;
            String[] stringArray;
            String string = this.getText();
            this.prefStore.setValue(String.valueOf(this.prefID) + LAST_ITEM_PREFIX, string);
            ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
            if (string.length() > 0 && this.isValidItem(string)) {
                arrayList.add(string);
            }
            String[] stringArray2 = stringArray = this.getItems();
            int n = stringArray.length;
            boolean n2 = false;
            while (string2 < n) {
                charSequence = stringArray2[string2];
                if (this.isValidItem((String)charSequence) && !arrayList.contains(charSequence)) {
                    arrayList.add(charSequence);
                }
                ++string2;
            }
            charSequence = new StringBuilder();
            for (String string3 : arrayList) {
                ((StringBuilder)charSequence).append(String.valueOf(string3) + prefSeparator);
            }
            if (((StringBuilder)charSequence).length() > 0) {
                String string3 = ((StringBuilder)charSequence).substring(0, ((StringBuilder)charSequence).length() - 1);
                this.prefStore.setValue(this.prefID, string3);
            }
        }
    }

    protected boolean isValidItem(String string) {
        return true;
    }

    protected void checkSubclass() {
    }
}

