/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.widgets;

import eu.geclipse.ui.widgets.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabComponent<T>
extends AbstractLaunchConfigurationTab {
    protected Button editButton;
    protected Button removeButton;
    protected Button addButton;
    protected ColumnLayoutData[] tabColumnsLayouts;
    protected TableViewer table;
    private IStructuredContentProvider contentProvider;
    private ITableLabelProvider labelProvider;
    private String[] tabColumnsHeaders;
    private String[] tabColumnsProperties;
    private int tabHeight;
    private List<Integer> columnsWidth = new ArrayList<Integer>();
    private ArrayList<CellEditor> cellEditors = new ArrayList();
    private ICellModifier cellModifier;
    private int buttonsPosition;
    private Object input;

    public TabComponent(IStructuredContentProvider iStructuredContentProvider, ITableLabelProvider iTableLabelProvider, List<String> list, Object object, int n, int n2) {
        this(iStructuredContentProvider, iTableLabelProvider, list, n, n2, 16384);
        this.input = object;
    }

    public TabComponent(IStructuredContentProvider iStructuredContentProvider, ITableLabelProvider iTableLabelProvider, List<String> list, int n, int n2) {
        this(iStructuredContentProvider, iTableLabelProvider, list, n, n2, 16384);
    }

    public TabComponent(IStructuredContentProvider iStructuredContentProvider, ITableLabelProvider iTableLabelProvider, List<String> list, int n, int n2, int n3) {
        this.contentProvider = iStructuredContentProvider;
        this.tabHeight = n;
        this.labelProvider = iTableLabelProvider;
        this.tabColumnsHeaders = new String[list.size()];
        this.tabColumnsProperties = new String[list.size()];
        this.tabColumnsHeaders = list.toArray(this.tabColumnsHeaders);
        this.tabColumnsProperties = list.toArray(this.tabColumnsProperties);
        this.tabColumnsLayouts = new ColumnLayoutData[this.tabColumnsHeaders.length];
        int n4 = 0;
        while (n4 < this.tabColumnsHeaders.length) {
            this.columnsWidth.add(n2);
            this.tabColumnsLayouts[n4] = new ColumnWeightData(this.columnsWidth.get(n4).intValue(), this.columnsWidth.get(n4).intValue(), false);
            ++n4;
        }
        this.buttonsPosition = n3;
    }

    public TabComponent(IStructuredContentProvider iStructuredContentProvider, ITableLabelProvider iTableLabelProvider, List<String> list, Object object, int n, List<Integer> list2, int n2) {
        this.contentProvider = iStructuredContentProvider;
        this.tabHeight = n;
        this.columnsWidth = list2;
        this.labelProvider = iTableLabelProvider;
        this.tabColumnsHeaders = new String[list.size()];
        this.tabColumnsProperties = new String[list.size()];
        this.tabColumnsHeaders = list.toArray(this.tabColumnsHeaders);
        this.tabColumnsProperties = list.toArray(this.tabColumnsProperties);
        this.tabColumnsLayouts = new ColumnLayoutData[this.tabColumnsHeaders.length];
        int n3 = 0;
        while (n3 < this.tabColumnsHeaders.length) {
            this.tabColumnsLayouts[n3] = new ColumnWeightData(this.columnsWidth.get(n3).intValue(), this.columnsWidth.get(n3).intValue(), false);
            ++n3;
        }
        this.buttonsPosition = n2;
        this.input = object;
    }

    public TabComponent(IStructuredContentProvider iStructuredContentProvider, ITableLabelProvider iTableLabelProvider, List<String> list, int n, List<Integer> list2, int n2) {
        this.contentProvider = iStructuredContentProvider;
        this.tabHeight = n;
        this.columnsWidth = list2;
        this.labelProvider = iTableLabelProvider;
        this.tabColumnsHeaders = new String[list.size()];
        this.tabColumnsProperties = new String[list.size()];
        this.tabColumnsHeaders = list.toArray(this.tabColumnsHeaders);
        this.tabColumnsProperties = list.toArray(this.tabColumnsProperties);
        this.tabColumnsLayouts = new ColumnLayoutData[this.tabColumnsHeaders.length];
        int n3 = 0;
        while (n3 < this.tabColumnsHeaders.length) {
            this.tabColumnsLayouts[n3] = new ColumnWeightData(this.columnsWidth.get(n3).intValue(), this.columnsWidth.get(n3).intValue(), false);
            ++n3;
        }
        this.buttonsPosition = n2;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = this.buttonsPosition == 1024 || this.buttonsPosition == 128 ? 1 : 2;
        GridData gridData = new GridData(768);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        this.createTable(composite2);
        this.createTableButtons(composite2);
        this.setLabels();
        Dialog.applyDialogFont((Control)composite2);
        this.addEditors();
        if (!this.cellEditors.isEmpty()) {
            CellEditor[] cellEditorArray = new CellEditor[this.cellEditors.size()];
            int n = 0;
            Iterator<CellEditor> iterator = this.cellEditors.iterator();
            while (iterator.hasNext()) {
                CellEditor cellEditor;
                cellEditorArray[n] = cellEditor = iterator.next();
                ++n;
            }
            this.table.setCellEditors(cellEditorArray);
            this.table.setCellModifier(this.cellModifier);
        }
    }

    protected void addEditors() {
    }

    protected void setCellModifier(ICellModifier iCellModifier) {
        this.cellModifier = iCellModifier;
    }

    protected void addComboEditor(ComboBoxCellEditor comboBoxCellEditor, String[] stringArray, boolean bl) {
        comboBoxCellEditor.create((Composite)this.table.getTable());
        comboBoxCellEditor.setItems(stringArray);
        if (bl) {
            comboBoxCellEditor.setStyle(8);
        }
        this.cellEditors.add((CellEditor)comboBoxCellEditor);
    }

    public void addEditor(CellEditor cellEditor) {
        cellEditor.create((Composite)this.table.getTable());
        this.cellEditors.add(cellEditor);
    }

    private void createTable(Composite composite) {
        Integer n3;
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.tabHeight;
        int n2 = 0;
        for (Integer n3 : this.columnsWidth) {
            n2 += n3.intValue();
        }
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(font);
        this.table = new TableViewer(composite2, 68354);
        n3 = this.table.getTable();
        TableLayout tableLayout = new TableLayout();
        n3.setLayout((Layout)tableLayout);
        n3.setHeaderVisible(true);
        n3.setFont(font);
        gridData = new GridData(1808);
        this.table.getControl().setLayoutData((Object)gridData);
        this.table.setContentProvider((IContentProvider)this.contentProvider);
        this.table.setInput(this.input);
        this.table.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.table.setColumnProperties(this.tabColumnsProperties);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TabComponent.this.handleTableSelectionChanged(selectionChangedEvent);
            }
        });
        this.table.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                if (!TabComponent.this.table.getSelection().isEmpty()) {
                    TabComponent.this.handleEditButtonSelected();
                }
            }
        });
        int n4 = 0;
        while (n4 < this.tabColumnsHeaders.length) {
            tableLayout.addColumnData(this.tabColumnsLayouts[n4]);
            TableColumn tableColumn = new TableColumn((Table)n3, 0, n4);
            tableColumn.setResizable(this.tabColumnsLayouts[n4].resizable);
            tableColumn.setText(this.tabColumnsHeaders[n4]);
            ++n4;
        }
        this.table.refresh();
    }

    public String getName() {
        return null;
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        int n = ((IStructuredSelection)selectionChangedEvent.getSelection()).size();
        this.editButton.setEnabled(n == 1);
        this.removeButton.setEnabled(n > 0);
    }

    protected void createTableButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = this.buttonsPosition == 1024 || this.buttonsPosition == 128 ? 3 : 1;
        GridData gridData = new GridData(130);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        if (this.buttonsPosition == 16384) {
            this.createVerticalSpacer(composite2, 1);
        }
        gridData = new GridData(1808);
        this.addButton = new Button(composite2, 8);
        this.addButton.setLayoutData((Object)gridData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TabComponent.this.handleAddButtonSelected();
            }
        });
        gridData = new GridData(1808);
        this.editButton = new Button(composite2, 8);
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TabComponent.this.handleEditButtonSelected();
            }
        });
        this.editButton.setEnabled(false);
        gridData = new GridData(1808);
        this.removeButton = new Button(composite2, 8);
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TabComponent.this.handleRemoveButtonSelected();
            }
        });
        this.removeButton.setEnabled(false);
    }

    protected boolean addVariable(T t) {
        boolean bl = true;
        TableItem[] tableItemArray = this.table.getTable().getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            Object object = tableItemArray[n].getData();
            if (object.equals(t)) {
                boolean bl2 = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("TabComponent.replace_table_item_question_title"), (String)Messages.getString("TabComponent.replace_table_item_question"));
                if (!bl2) {
                    bl = false;
                    break;
                }
                this.table.remove(object);
                break;
            }
            ++n;
        }
        if (bl) {
            this.table.add(t);
        }
        return bl;
    }

    public ArrayList<T> getInput() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TableItem[] tableItemArray = this.table.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            arrayList.add(tableItem.getData());
            ++n2;
        }
        return arrayList;
    }

    protected abstract void handleRemoveButtonSelected();

    protected abstract void handleAddButtonSelected();

    protected abstract void handleEditButtonSelected();

    protected abstract void setLabels();
}

