/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IGridPreferences;
import eu.geclipse.ui.Extensions;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.providers.ConnectionViewContentProvider;
import eu.geclipse.ui.providers.ConnectionViewLabelProvider;
import eu.geclipse.ui.widgets.StoredCombo;
import eu.geclipse.ui.wizards.IConnectionTokenValidator;
import eu.geclipse.ui.wizards.Messages;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Tree;

public class ConnectionDefinitionWizardPage
extends WizardPage {
    private static final String SEPARATOR = ":";
    protected TreeViewer viewer;
    private String currentURIType;
    private Composite mainComp;
    private Label schemeLabel;
    private Label uriLabel;
    private Label schemeSpecificPartLabel;
    private Label authorityLabel;
    private Label userInfoLabel;
    private Label hostLabel;
    private Label portLabel;
    private Label pathLabel;
    private Label queryLabel;
    private Label fragmentLabel;
    private Combo schemeCombo;
    private StoredCombo uriCombo;
    private StoredCombo schemeSpecificPartCombo;
    private StoredCombo authorityCombo;
    private StoredCombo userInfoCombo;
    private StoredCombo hostCombo;
    private StoredCombo portCombo;
    private StoredCombo pathCombo;
    private StoredCombo queryCombo;
    private StoredCombo fragmentCombo;
    private Link pathLink;
    private IConnectionTokenValidator validator;

    public ConnectionDefinitionWizardPage() {
        super(Messages.getString("ConnectionDefinitionWizardPage.name"), Messages.getString("ConnectionDefinitionWizardPage.title"), null);
        this.setDescription(Messages.getString("ConnectionDefinitionWizardPage.description"));
    }

    public void createControl(Composite composite) {
        this.mainComp = new Composite(composite, 0);
        this.mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.mainComp.setLayoutData((Object)gridData);
        this.schemeLabel = new Label(this.mainComp, 0);
        this.schemeLabel.setText(Messages.getString("ConnectionDefinitionWizardPage.scheme_label"));
        gridData = new GridData();
        gridData.minimumHeight = 0;
        this.schemeLabel.setLayoutData((Object)gridData);
        this.schemeCombo = new Combo(this.mainComp, 8);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumHeight = 0;
        this.schemeCombo.setLayoutData((Object)gridData);
        this.schemeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ConnectionDefinitionWizardPage.this.updateUI();
            }
        });
        this.uriLabel = new Label(this.mainComp, 0);
        this.uriCombo = this.createEditorField(this.mainComp, this.uriLabel, Messages.getString("ConnectionDefinitionWizardPage.uri_label"));
        this.schemeSpecificPartLabel = new Label(this.mainComp, 0);
        this.schemeSpecificPartCombo = this.createEditorField(this.mainComp, this.schemeSpecificPartLabel, Messages.getString("ConnectionDefinitionWizardPage.scheme_spec_label"));
        this.authorityLabel = new Label(this.mainComp, 0);
        this.authorityCombo = this.createEditorField(this.mainComp, this.authorityLabel, Messages.getString("ConnectionDefinitionWizardPage.authority_label"));
        this.userInfoLabel = new Label(this.mainComp, 0);
        this.userInfoCombo = this.createEditorField(this.mainComp, this.userInfoLabel, Messages.getString("ConnectionDefinitionWizardPage.user_info_label"));
        this.hostLabel = new Label(this.mainComp, 0);
        this.hostCombo = this.createEditorField(this.mainComp, this.hostLabel, Messages.getString("ConnectionDefinitionWizardPage.host_label"));
        this.portLabel = new Label(this.mainComp, 0);
        this.portCombo = this.createEditorField(this.mainComp, this.portLabel, Messages.getString("ConnectionDefinitionWizardPage.port_label"));
        this.pathLabel = new Label(this.mainComp, 0);
        this.pathCombo = this.createEditorField(this.mainComp, this.pathLabel, Messages.getString("ConnectionDefinitionWizardPage.path_label"));
        this.queryLabel = new Label(this.mainComp, 0);
        this.queryCombo = this.createEditorField(this.mainComp, this.queryLabel, Messages.getString("ConnectionDefinitionWizardPage.query_label"));
        this.fragmentLabel = new Label(this.mainComp, 0);
        this.fragmentCombo = this.createEditorField(this.mainComp, this.fragmentLabel, Messages.getString("ConnectionDefinitionWizardPage.fragment_label"));
        Group group = new Group(this.mainComp, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.getString("ConnectionDefinitionWizardPage.browse_title"));
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        group.setLayoutData((Object)gridData);
        this.pathLink = new Link((Composite)group, 0);
        this.pathLink.setText(Messages.getString("ConnectionDefinitionWizardPage.browse_link"));
        gridData = new GridData();
        this.pathLink.setLayoutData((Object)gridData);
        this.viewer = new TreeViewer((Composite)group, 2820);
        ConnectionViewContentProvider connectionViewContentProvider = new ConnectionViewContentProvider();
        this.viewer.setContentProvider((IContentProvider)connectionViewContentProvider);
        ConnectionViewLabelProvider connectionViewLabelProvider = new ConnectionViewLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)connectionViewLabelProvider);
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                boolean bl = true;
                if (object2 instanceof IGridConnectionElement) {
                    bl = ((IGridConnectionElement)object2).isFolder();
                }
                return bl;
            }
        });
        Tree tree = this.viewer.getTree();
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData);
        this.initializeSchemeCombo(this.schemeCombo);
        this.schemeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ConnectionDefinitionWizardPage.this.setupFields();
            }
        });
        this.pathLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConnectionDefinitionWizardPage.this.initializeBrowser();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ConnectionDefinitionWizardPage.this.handleDoubleClick();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ConnectionDefinitionWizardPage.this.handleSelectionChanged(selectionChangedEvent.getSelection());
            }
        });
        GridModel.getRoot().addGridModelListener(new IGridModelListener(){

            public void gridModelChanged(IGridModelEvent iGridModelEvent) {
                ConnectionDefinitionWizardPage.this.handleGridModelChanged(iGridModelEvent);
            }
        });
        this.setupFields();
        this.setControl((Control)this.mainComp);
    }

    protected StoredCombo createEditorField(Composite composite, Label label, String string) {
        label.setText(string);
        GridData gridData = new GridData();
        gridData.minimumHeight = 0;
        label.setLayoutData((Object)gridData);
        StoredCombo storedCombo = new StoredCombo(composite, 0);
        GridData gridData2 = new GridData(768);
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.minimumHeight = 0;
        storedCombo.setLayoutData(gridData2);
        storedCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ConnectionDefinitionWizardPage.this.updateUI();
            }
        });
        return storedCombo;
    }

    protected URI getURI() {
        this.setErrorMessage(null);
        URI uRI = null;
        String string = this.schemeCombo.getText();
        try {
            if (this.uriCombo.isVisible()) {
                uRI = new URI(this.uriCombo.getText());
            } else if (this.schemeSpecificPartCombo.isVisible()) {
                String string2 = this.schemeSpecificPartCombo.getText();
                String string3 = this.fragmentCombo.isVisible() ? this.fragmentCombo.getText() : null;
                uRI = new URI(string, string2, string3);
            } else if (!this.hostCombo.isVisible()) {
                String string4 = this.authorityCombo.getText();
                String string5 = this.pathCombo.isVisible() ? this.pathCombo.getText() : null;
                String string6 = this.queryCombo.isVisible() ? this.queryCombo.getText() : null;
                String string7 = this.fragmentCombo.isVisible() ? this.fragmentCombo.getText() : null;
                uRI = new URI(string, string4, string5, string6, string7);
            } else {
                String string8 = this.userInfoCombo.isVisible() ? this.userInfoCombo.getText() : null;
                String string9 = this.hostCombo.getText();
                int n = this.portCombo.isVisible() ? Integer.parseInt(this.portCombo.getText()) : -1;
                String string10 = this.pathCombo.isVisible() ? this.pathCombo.getText() : null;
                String string11 = this.queryCombo.isVisible() ? this.queryCombo.getText() : null;
                String string12 = this.fragmentCombo.isVisible() ? this.fragmentCombo.getText() : null;
                uRI = new URI(string, string8, string9, n, string10, string11, string12);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setErrorMessage(String.valueOf(Messages.getString("ConnectionDefinitionWizardPage.invalid_uri_error")) + uRISyntaxException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(String.valueOf(Messages.getString("ConnectionDefinitionWizardPage.invalid_uri_error")) + numberFormatException.getMessage());
        }
        return uRI;
    }

    protected void handleDoubleClick() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (this.viewer.isExpandable(object)) {
            boolean bl = this.viewer.getExpandedState(object);
            this.viewer.setExpandedState(object, !bl);
        }
    }

    protected void handleGridModelChanged(final IGridModelEvent iGridModelEvent) {
        Control control = this.viewer.getControl();
        if (!control.isDisposed()) {
            Display display = control.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!ConnectionDefinitionWizardPage.this.viewer.getControl().isDisposed()) {
                        IGridElement iGridElement = iGridModelEvent.getSource();
                        ConnectionDefinitionWizardPage.this.viewer.refresh((Object)iGridElement);
                    }
                }
            });
        }
    }

    protected void handleSelectionChanged(ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        Object object;
        if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) != null && object instanceof IGridConnectionElement) {
            IGridConnectionElement iGridConnectionElement = (IGridConnectionElement)object;
            try {
                IFileStore iFileStore = iGridConnectionElement.getConnectionFileStore();
                GEclipseURI gEclipseURI = new GEclipseURI(iFileStore.toURI());
                URI uRI = gEclipseURI.toSlaveURI();
                if (this.currentURIType.equals("raw")) {
                    this.uriCombo.setText(uRI.toString());
                } else if (this.currentURIType.equals("opaque")) {
                    this.schemeSpecificPartCombo.setText(uRI.getSchemeSpecificPart());
                } else if (this.currentURIType.equals("hierarchical") || this.currentURIType.equals("server")) {
                    this.pathCombo.setText(uRI.getPath());
                }
            }
            catch (CoreException coreException) {
                this.setErrorMessage(String.valueOf(Messages.getString("ConnectionDefinitionWizardPage.path_error")) + coreException.getMessage());
            }
        }
    }

    protected void initializeBrowser() {
        this.viewer.setInput(null);
        URI uRI = this.getURI();
        if (uRI != null) {
            try {
                GEclipseURI gEclipseURI = new GEclipseURI(uRI);
                URI uRI2 = gEclipseURI.toMasterURI();
                IGridPreferences iGridPreferences = GridModel.getPreferences();
                IGridConnection iGridConnection = iGridPreferences.createTemporaryConnection(uRI2);
                this.viewer.setInput((Object)iGridConnection);
            }
            catch (GridModelException gridModelException) {
                this.setErrorMessage(String.valueOf(Messages.getString("ConnectionDefinitionWizardPage.temp_connection_error")) + gridModelException.getMessage());
                NewProblemDialog.openProblem(this.getShell(), Messages.getString("ConnectionDefinitionWizardPage.connection_error_title"), Messages.getString("ConnectionDefinitionWizardPage.connection_error_text"), gridModelException);
            }
        }
    }

    protected void initializeSchemeCombo(Combo combo) {
        List list = eu.geclipse.core.Extensions.getRegisteredFilesystemSchemes();
        String[] stringArray = list.toArray(new String[list.size()]);
        combo.setItems(stringArray);
    }

    protected void resetFields() {
        this.setActive(this.uriCombo, this.uriLabel, Messages.getString("ConnectionDefinitionWizardPage.uri_raw_label"));
        this.setActive(this.schemeSpecificPartCombo, this.schemeSpecificPartLabel, null);
        this.setActive(this.authorityCombo, this.authorityLabel, null);
        this.setActive(this.userInfoCombo, this.userInfoLabel, null);
        this.setActive(this.hostCombo, this.hostLabel, null);
        this.setActive(this.portCombo, this.portLabel, null);
        this.setActive(this.pathCombo, this.pathLabel, null);
        this.setActive(this.queryCombo, this.queryLabel, null);
        this.setActive(this.fragmentCombo, this.fragmentLabel, null);
        String string = this.schemeCombo.getText();
        if (!this.isEmpty(string)) {
            this.uriCombo.setText(String.valueOf(string) + SEPARATOR);
        }
        this.currentURIType = "raw";
        this.validator = null;
    }

    protected void setupFields() {
        this.resetFields();
        String string = this.schemeCombo.getText();
        IConfigurationElement iConfigurationElement = Extensions.getRegisteredEFSExtension(string);
        if (iConfigurationElement != null) {
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
            if (iConfigurationElementArray != null && iConfigurationElementArray.length == 1) {
                this.setActive(this.uriCombo, this.uriLabel, null);
                this.processURIScheme(iConfigurationElementArray[0]);
            }
            try {
                this.validator = (IConnectionTokenValidator)iConfigurationElement.createExecutableExtension("validator");
            }
            catch (CoreException coreException) {}
        }
        this.mainComp.layout();
        this.updateUI();
    }

    protected void updateUI() {
        URI uRI = this.getURI();
        this.viewer.getTree().setEnabled(uRI != null);
        this.pathLink.setEnabled(uRI != null);
        this.setPageComplete(this.validatePage() && uRI != null);
    }

    protected boolean validatePage() {
        String string = null;
        if (this.validator != null) {
            if (this.uriCombo.isVisible()) {
                string = this.validator.validateToken("uri", this.uriCombo.getText());
            }
            if (string == null && this.schemeSpecificPartCombo.isVisible()) {
                string = this.validator.validateToken("scheme-specific-part", this.schemeSpecificPartCombo.getText());
            }
            if (string == null && this.authorityCombo.isVisible()) {
                string = this.validator.validateToken("authority", this.authorityCombo.getText());
            }
            if (string == null && this.userInfoCombo.isVisible()) {
                string = this.validator.validateToken("user-info", this.userInfoCombo.getText());
            }
            if (string == null && this.hostCombo.isVisible()) {
                string = this.validator.validateToken("host", this.hostCombo.getText());
            }
            if (string == null && this.portCombo.isVisible()) {
                string = this.validator.validateToken("port", this.portCombo.getText());
            }
            if (string == null && this.pathCombo.isVisible()) {
                string = this.validator.validateToken("path", this.pathCombo.getText());
            }
            if (string == null && this.queryCombo.isVisible()) {
                string = this.validator.validateToken("query", this.queryCombo.getText());
            }
            if (string == null && this.fragmentCombo.isVisible()) {
                string = this.validator.validateToken("fragment", this.fragmentCombo.getText());
            }
            this.setErrorMessage(string);
        }
        return string == null;
    }

    private void processURIScheme(IConfigurationElement iConfigurationElement) {
        this.currentURIType = iConfigurationElement.getName();
        if (this.currentURIType.equals("raw")) {
            this.processRawURIScheme(iConfigurationElement);
        } else if (this.currentURIType.equals("opaque")) {
            this.processOpaqueURIScheme(iConfigurationElement);
        } else if (this.currentURIType.equals("hierarchical")) {
            this.processHierarchicalURIScheme(iConfigurationElement);
        } else if (this.currentURIType.equals("server")) {
            this.processServerURIScheme(iConfigurationElement);
        }
    }

    private void processServerURIScheme(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("user-info");
        String string2 = iConfigurationElement.getAttribute("host");
        String string3 = iConfigurationElement.getAttribute("port");
        String string4 = iConfigurationElement.getAttribute("path");
        String string5 = iConfigurationElement.getAttribute("query");
        String string6 = iConfigurationElement.getAttribute("fragment");
        this.setActive(this.userInfoCombo, this.userInfoLabel, string);
        this.setActive(this.hostCombo, this.hostLabel, string2);
        this.setActive(this.portCombo, this.portLabel, string3);
        this.setActive(this.pathCombo, this.pathLabel, string4);
        this.setActive(this.queryCombo, this.queryLabel, string5);
        this.setActive(this.fragmentCombo, this.fragmentLabel, string6);
        String string7 = this.schemeCombo.getText();
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        this.userInfoCombo.setPreferences(iPreferenceStore, String.valueOf(string7) + SEPARATOR + "user-info");
        this.hostCombo.setPreferences(iPreferenceStore, String.valueOf(string7) + SEPARATOR + "host");
        this.portCombo.setPreferences(iPreferenceStore, String.valueOf(string7) + SEPARATOR + "port");
        this.pathCombo.setPreferences(iPreferenceStore, String.valueOf(string7) + SEPARATOR + "path");
        this.queryCombo.setPreferences(iPreferenceStore, String.valueOf(string7) + SEPARATOR + "query");
        this.fragmentCombo.setPreferences(iPreferenceStore, String.valueOf(string7) + SEPARATOR + "fragment");
    }

    private void processHierarchicalURIScheme(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("authority");
        String string2 = iConfigurationElement.getAttribute("path");
        String string3 = iConfigurationElement.getAttribute("query");
        String string4 = iConfigurationElement.getAttribute("fragment");
        this.setActive(this.authorityCombo, this.authorityLabel, string);
        this.setActive(this.pathCombo, this.pathLabel, string2);
        this.setActive(this.queryCombo, this.queryLabel, string3);
        this.setActive(this.fragmentCombo, this.fragmentLabel, string4);
        String string5 = this.schemeCombo.getText();
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        this.authorityCombo.setPreferences(iPreferenceStore, String.valueOf(string5) + SEPARATOR + "authority");
        this.pathCombo.setPreferences(iPreferenceStore, String.valueOf(string5) + SEPARATOR + "path");
        this.queryCombo.setPreferences(iPreferenceStore, String.valueOf(string5) + SEPARATOR + "query");
        this.fragmentCombo.setPreferences(iPreferenceStore, String.valueOf(string5) + SEPARATOR + "fragment");
    }

    private void processOpaqueURIScheme(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("scheme-specific-part");
        String string2 = iConfigurationElement.getAttribute("fragment");
        this.setActive(this.schemeSpecificPartCombo, this.schemeSpecificPartLabel, string);
        this.setActive(this.fragmentCombo, this.fragmentLabel, string2);
        String string3 = this.schemeCombo.getText();
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        this.schemeSpecificPartCombo.setPreferences(iPreferenceStore, String.valueOf(string3) + SEPARATOR + "scheme-specific-part");
        this.fragmentCombo.setPreferences(iPreferenceStore, String.valueOf(string3) + SEPARATOR + "fragment");
    }

    private void processRawURIScheme(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("uri");
        this.setActive(this.uriCombo, this.uriLabel, string);
        String string2 = this.schemeCombo.getText();
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        this.uriCombo.setPreferences(iPreferenceStore, String.valueOf(string2) + SEPARATOR + "uri");
    }

    private void setActive(StoredCombo storedCombo, Label label, String string) {
        if (!this.isEmpty(string)) {
            label.setText(String.valueOf(string) + SEPARATOR);
        }
        label.setVisible(!this.isEmpty(string));
        storedCombo.setVisible(!this.isEmpty(string));
        ((GridData)label.getLayoutData()).exclude = this.isEmpty(string);
        ((GridData)storedCombo.getLayoutData()).exclude = this.isEmpty(string);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

