/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.ui.wizards.Messages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class ConnectionLocationWizardPage
extends WizardNewFileCreationPage {
    private URI initialContent;
    private IStructuredSelection initialSelection;

    public ConnectionLocationWizardPage(String string, IStructuredSelection iStructuredSelection) {
        super(string, iStructuredSelection);
        this.initialSelection = iStructuredSelection;
    }

    public String getConnectionFilename() {
        String string = this.getFileName();
        return "." + string + ".fs";
    }

    protected InputStream getInitialContents() {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.initialContent != null) {
            String string = this.initialContent.toString();
            byte[] byArray = string.getBytes();
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        return byteArrayInputStream;
    }

    protected String getNewFileLabel() {
        return Messages.getString("ConnectionLocationWizardPage.connection_name");
    }

    protected void initialPopulateContainerNameField() {
        IGridElement iGridElement = null;
        if (!this.initialSelection.isEmpty()) {
            for (Object e : this.initialSelection.toList()) {
                if (!(e instanceof IGridElement)) continue;
                IGridProject iGridProject = ((IGridElement)e).getProject();
                IGridElement iGridElement2 = iGridProject.findChild(IGridProject.DIR_MOUNTS);
                IGridElement iGridElement3 = (IGridElement)e;
                while (iGridElement3 != null) {
                    if (iGridElement3 == iGridElement2) {
                        iGridElement = (IGridElement)e;
                        break;
                    }
                    iGridElement3 = iGridElement3.getParent();
                }
                if (iGridElement != null) continue;
                iGridElement = iGridElement2;
            }
        }
        if (iGridElement != null) {
            this.setContainerFullPath(iGridElement.getPath());
        } else {
            super.initialPopulateContainerNameField();
        }
    }

    protected void setInitialContent(URI uRI) {
        this.initialContent = uRI;
    }

    protected boolean validatePage() {
        boolean bl = super.validatePage();
        if (bl) {
            IPath iPath = this.getContainerFullPath();
            String string = this.getConnectionFilename();
            IPath iPath2 = iPath.append(string);
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
            if (iWorkspaceRoot.exists(iPath2)) {
                bl = false;
                this.setErrorMessage(Messages.getString("ConnectionLocationWizardPage.connection_already_exists"));
            }
        }
        return bl;
    }
}

