/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IConnectionManager;
import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.ui.wizards.Messages;
import java.net.URI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConnectionNameWizardPage
extends WizardPage {
    private Text nameText;
    private URI initialContent;

    public ConnectionNameWizardPage() {
        super(Messages.getString("ConnectionNameWizardPage.name"), Messages.getString("ConnectionNameWizardPage.title"), null);
        this.setDescription(Messages.getString("ConnectionNameWizardPage.description"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("ConnectionNameWizardPage.name_label"));
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.nameText = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.nameText.setLayoutData((Object)gridData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ConnectionNameWizardPage.this.validatePage();
            }
        });
        this.setControl((Control)composite2);
        this.validatePage();
    }

    public String getConnectionName() {
        return this.nameText.getText();
    }

    public void setConnectionName(String string) {
        this.nameText.setText(string);
    }

    protected boolean validatePage() {
        boolean bl = true;
        this.setErrorMessage(null);
        String string = this.getConnectionName();
        if (string != null && string.length() != 0) {
            IConnectionManager iConnectionManager = GridModel.getConnectionManager();
            IGridConnection[] iGridConnectionArray = iConnectionManager.getGlobalConnections();
            if (iGridConnectionArray != null) {
                IGridConnection[] iGridConnectionArray2 = iGridConnectionArray;
                int n = iGridConnectionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridConnection iGridConnection = iGridConnectionArray2[n2];
                    if (iGridConnection.getName().equals(string)) {
                        this.setErrorMessage(Messages.getString("ConnectionNameWizardPage.connection_already_exists"));
                        bl = false;
                    }
                    ++n2;
                }
            }
        } else {
            bl = false;
        }
        this.setPageComplete(bl);
        return bl;
    }
}

