/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridPreferences;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.ConnectionDefinitionWizardPage;
import eu.geclipse.ui.wizards.ConnectionLocationWizardPage;
import eu.geclipse.ui.wizards.ConnectionNameWizardPage;
import eu.geclipse.ui.wizards.Messages;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ConnectionWizard
extends Wizard
implements INewWizard {
    protected static final String CONNECTION_PREFIX = ".";
    protected static final String CONNECTION_SUFFIX = ".fs";
    IWizardPage firstPage;
    private boolean createGlobalConnection;
    private ISelection initialSelection;
    private ConnectionDefinitionWizardPage definitionPage;

    public ConnectionWizard() {
        this(false);
    }

    public ConnectionWizard(boolean bl) {
        URL uRL = Activator.getDefault().getBundle().getResource("icons/wizban/newconn_wiz.gif");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)uRL));
        this.setNeedsProgressMonitor(true);
        this.createGlobalConnection = bl;
    }

    public void addPages() {
        if (this.createGlobalConnection) {
            this.firstPage = new ConnectionNameWizardPage();
        } else {
            this.firstPage = new ConnectionLocationWizardPage(Messages.getString("ConnectionWizard.location_page_name"), (IStructuredSelection)this.initialSelection);
            this.firstPage.setTitle(Messages.getString("ConnectionWizard.location_page_title"));
            this.firstPage.setDescription(Messages.getString("ConnectionWizard.location_page_description"));
        }
        this.addPage(this.firstPage);
        this.definitionPage = new ConnectionDefinitionWizardPage();
        this.addPage((IWizardPage)this.definitionPage);
    }

    public boolean canFinish() {
        IWizardContainer iWizardContainer = this.getContainer();
        IWizardPage iWizardPage = iWizardContainer.getCurrentPage();
        return iWizardPage != this.firstPage && super.canFinish();
    }

    public String getWindowTitle() {
        return Messages.getString("ConnectionWizard.window_title");
    }

    public boolean performFinish() {
        boolean bl = false;
        URI uRI = this.definitionPage.getURI();
        if (uRI != null) {
            bl = this.createGlobalConnection ? this.createGlobalConnection() : this.createLocalConnection();
        }
        return bl;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.initialSelection = iStructuredSelection;
    }

    private boolean createGlobalConnection() {
        boolean bl = false;
        ConnectionNameWizardPage connectionNameWizardPage = (ConnectionNameWizardPage)this.firstPage;
        String string = connectionNameWizardPage.getConnectionName();
        URI uRI = this.definitionPage.getURI();
        if (uRI != null) {
            try {
                GEclipseURI gEclipseURI = new GEclipseURI(uRI);
                IGridPreferences iGridPreferences = GridModel.getPreferences();
                iGridPreferences.createGlobalConnection(string, gEclipseURI.toMasterURI());
                bl = true;
            }
            catch (GridModelException gridModelException) {
                connectionNameWizardPage.setErrorMessage(gridModelException.getMessage());
            }
        }
        if (!bl) {
            this.setCurrentErrorMessage((IWizardPage)connectionNameWizardPage);
        }
        return bl;
    }

    private boolean createLocalConnection() {
        boolean bl = false;
        ConnectionLocationWizardPage connectionLocationWizardPage = (ConnectionLocationWizardPage)this.firstPage;
        URI uRI = this.definitionPage.getURI();
        if (uRI != null) {
            IPath iPath = connectionLocationWizardPage.getContainerFullPath();
            iPath = iPath.append(connectionLocationWizardPage.getFileName());
            IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath);
            try {
                GEclipseURI gEclipseURI = new GEclipseURI(uRI);
                iFolder.createLink(gEclipseURI.toMasterURI(), 16, null);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
            boolean bl2 = bl = iFolder != null && iFolder.exists();
        }
        if (!bl) {
            this.setCurrentErrorMessage((IWizardPage)connectionLocationWizardPage);
        }
        return bl;
    }

    private void setCurrentErrorMessage(IWizardPage iWizardPage) {
        String string = iWizardPage.getErrorMessage();
        WizardPage wizardPage = (WizardPage)this.getContainer().getCurrentPage();
        wizardPage.setErrorMessage(string);
    }
}

